/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.commons.transformations;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.kie.pmml.api.enums.DATA_TYPE;
import org.kie.pmml.api.enums.OP_TYPE;
import org.kie.pmml.commons.model.KiePMMLExtension;
import org.kie.pmml.commons.model.ProcessingDTO;
import org.kie.pmml.commons.model.abstracts.AbstractKiePMMLComponent;
import org.kie.pmml.commons.model.expressions.KiePMMLExpression;
import org.kie.pmml.commons.model.tuples.KiePMMLNameValue;
import org.kie.pmml.commons.transformations.KiePMMLParameterField;

public class KiePMMLDefineFunction
extends AbstractKiePMMLComponent
implements Serializable {
    private static final long serialVersionUID = 9187889880911645935L;
    private final OP_TYPE opType;
    private final List<KiePMMLParameterField> parameterFields;
    private final KiePMMLExpression kiePMMLExpression;
    private DATA_TYPE dataType;

    public KiePMMLDefineFunction(String name, List<KiePMMLExtension> extensions, String opType, List<KiePMMLParameterField> parameterFields, KiePMMLExpression kiePMMLExpression) {
        super(name, extensions);
        this.opType = OP_TYPE.byName(opType);
        this.parameterFields = parameterFields;
        this.kiePMMLExpression = kiePMMLExpression;
    }

    public OP_TYPE getOpType() {
        return this.opType;
    }

    public List<KiePMMLParameterField> getParameterFields() {
        return Collections.unmodifiableList(this.parameterFields);
    }

    public DATA_TYPE getDataType() {
        return this.dataType;
    }

    public Object evaluate(ProcessingDTO processingDTO, List<Object> paramValues) {
        ArrayList<KiePMMLNameValue> kiePMMLNameValues = new ArrayList<KiePMMLNameValue>();
        if (this.parameterFields != null) {
            if (paramValues == null || paramValues.size() < this.parameterFields.size()) {
                throw new IllegalArgumentException("Expected at least " + this.parameterFields.size() + " arguments for " + this.name + " DefineFunction");
            }
            for (int i = 0; i < this.parameterFields.size(); ++i) {
                kiePMMLNameValues.add(new KiePMMLNameValue(this.parameterFields.get(i).getName(), paramValues.get(i)));
            }
        }
        for (KiePMMLNameValue kiePMMLNameValue : kiePMMLNameValues) {
            processingDTO.addKiePMMLNameValue(kiePMMLNameValue);
        }
        return this.kiePMMLExpression.evaluate(processingDTO);
    }
}

