/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.validator.runtime.jaxrs;

import java.util.List;
import javax.validation.ValidationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.api.validation.ResteasyViolationException;
import org.jboss.resteasy.api.validation.ViolationReport;

@Provider
public class ResteasyViolationExceptionMapper
implements ExceptionMapper<ValidationException> {
    @Override
    public Response toResponse(ValidationException exception) {
        if (!(exception instanceof ResteasyViolationException)) {
            throw exception;
        }
        ResteasyViolationException restEasyException = (ResteasyViolationException)exception;
        Exception e = restEasyException.getException();
        if (e != null | restEasyException.getReturnValueViolations().size() != 0) {
            throw restEasyException;
        }
        return this.buildViolationReportResponse(restEasyException);
    }

    protected Response buildViolationReportResponse(ResteasyViolationException exception) {
        Response.ResponseBuilder builder = Response.status(Response.Status.BAD_REQUEST);
        builder.header("validation-exception", "true");
        MediaType mediaType = this.getAcceptMediaType(exception.getAccept());
        if (mediaType != null) {
            builder.type(mediaType);
            builder.entity(new ViolationReport(exception));
            return builder.build();
        }
        builder.type("text/plain");
        builder.entity(exception.toString());
        return builder.build();
    }

    private MediaType getAcceptMediaType(List<MediaType> accept) {
        for (MediaType mt : accept) {
            if (MediaType.APPLICATION_XML_TYPE.getType().equals(mt.getType()) && MediaType.APPLICATION_XML_TYPE.getSubtype().equals(mt.getSubtype())) {
                return MediaType.APPLICATION_XML_TYPE;
            }
            if (!MediaType.APPLICATION_JSON_TYPE.getType().equals(mt.getType()) || !MediaType.APPLICATION_JSON_TYPE.getSubtype().equals(mt.getSubtype())) continue;
            return MediaType.APPLICATION_JSON_TYPE;
        }
        return null;
    }
}

