/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.runtime.interceptor.check;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.security.UnauthorizedException;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.spi.runtime.AuthorizationController;
import io.quarkus.security.spi.runtime.SecurityCheck;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

public class AuthenticatedCheck
implements SecurityCheck {
    public static final AuthenticatedCheck INSTANCE = new AuthenticatedCheck();
    private volatile AuthorizationController authorizationController;

    private AuthenticatedCheck() {
    }

    @Override
    public void apply(SecurityIdentity identity, Method method, Object[] parameters) {
        if (this.isAuthorizationDisabled()) {
            return;
        }
        if (identity.isAnonymous()) {
            throw new UnauthorizedException();
        }
    }

    private boolean isAuthorizationDisabled() {
        if (this.authorizationController != null) {
            return !this.authorizationController.isAuthorizationEnabled();
        }
        ArcContainer container = Arc.container();
        if (container == null || !container.isRunning()) {
            return false;
        }
        InstanceHandle<AuthorizationController> instance = container.instance(AuthorizationController.class, new Annotation[0]);
        if (instance.isAvailable()) {
            this.authorizationController = instance.get();
            return !instance.get().isAuthorizationEnabled();
        }
        return false;
    }
}

