/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.impl;

import io.smallrye.reactive.messaging.i18n.ProviderExceptions;
import io.smallrye.reactive.messaging.i18n.ProviderMessages;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigValue;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.Converter;

public class ConnectorConfig
implements Config {
    public static final String CHANNEL_ENABLED_PROPERTY = "enabled";
    public static final String BROADCAST_PROPERTY = "broadcast";
    public static final String MERGE_PROPERTY = "merge";
    private final String prefix;
    private final Config overall;
    private final String name;
    private final String connector;
    private static final Pattern NON_ALPHA = Pattern.compile("\\W");

    protected ConnectorConfig(String prefix, Config overall, String channel) {
        this.prefix = Objects.requireNonNull(prefix, ProviderMessages.msg.prefixMustNotBeSet());
        this.overall = Objects.requireNonNull(overall, ProviderMessages.msg.configMustNotBeSet());
        this.name = Objects.requireNonNull(channel, ProviderMessages.msg.channelMustNotBeSet());
        Optional<String> value = overall.getOptionalValue(this.channelKey("connector"), String.class);
        this.connector = value.orElseGet(() -> overall.getOptionalValue(this.channelKey("type"), String.class).orElseThrow(() -> ProviderExceptions.ex.illegalArgumentChannelConnectorConfiguration(this.name)));
        for (String key : overall.getPropertyNames()) {
            if (!this.channelKey("channel-name").equalsIgnoreCase(key)) continue;
            throw ProviderExceptions.ex.illegalArgumentInvalidChannelConfiguration(this.name);
        }
    }

    private String channelKey(String keyName) {
        return this.name.contains(".") ? this.prefix + "\"" + this.name + "\"." + keyName : this.prefix + this.name + "." + keyName;
    }

    private String connectorKey(String keyName) {
        return "mp.messaging.connector." + this.connector + "." + keyName;
    }

    @Override
    public <T> T getValue(String propertyName, Class<T> propertyType) {
        if ("channel-name".equalsIgnoreCase(propertyName)) {
            return this.convert(this.name, propertyType);
        }
        if ("connector".equalsIgnoreCase(propertyName) || "type".equalsIgnoreCase(propertyName)) {
            return this.convert(this.connector, propertyType);
        }
        Optional<T> maybeResult = this.overall.getOptionalValue(this.channelKey(propertyName), propertyType);
        if (maybeResult.isPresent()) {
            return maybeResult.get();
        }
        maybeResult = this.overall.getOptionalValue(this.connectorKey(propertyName), propertyType);
        if (maybeResult.isPresent()) {
            return maybeResult.get();
        }
        throw ProviderExceptions.ex.noSuchElementForAttribute(propertyName, this.name, this.channelKey(propertyName), this.connectorKey(propertyName));
    }

    @Override
    public ConfigValue getConfigValue(String propertyName) {
        if ("channel-name".equalsIgnoreCase(propertyName)) {
            return new ConfigValueImpl("channel-name", this.name);
        }
        if ("connector".equalsIgnoreCase(propertyName) || "type".equalsIgnoreCase(propertyName)) {
            return new ConfigValueImpl("connector", this.connector);
        }
        ConfigValue value = this.overall.getConfigValue(this.channelKey(propertyName));
        if (value.getRawValue() == null) {
            return this.overall.getConfigValue(this.connectorKey(propertyName));
        }
        return value;
    }

    @Override
    public <T> Optional<T> getOptionalValue(String propertyName, Class<T> propertyType) {
        if ("channel-name".equalsIgnoreCase(propertyName)) {
            return this.convertOptional(this.name, propertyType);
        }
        if ("connector".equalsIgnoreCase(propertyName) || "type".equalsIgnoreCase(propertyName)) {
            return this.convertOptional(this.connector, propertyType);
        }
        Optional<T> maybe = this.overall.getOptionalValue(this.channelKey(propertyName), propertyType);
        return maybe.isPresent() ? maybe : this.overall.getOptionalValue(this.connectorKey(propertyName), propertyType);
    }

    private <T> T convert(String rawValue, Class<T> propertyType) {
        Optional<Converter<T>> converter = this.overall.getConverter(propertyType);
        if (!converter.isPresent()) {
            if (propertyType.isAssignableFrom(String.class)) {
                return propertyType.cast(rawValue);
            }
            throw ProviderExceptions.ex.noConverterForType(propertyType);
        }
        T result = converter.get().convert(rawValue);
        if (result == null) {
            throw ProviderExceptions.ex.converterReturnedNull(converter.get(), rawValue);
        }
        return result;
    }

    private <T> Optional<T> convertOptional(String rawValue, Class<T> propertyType) {
        Optional<Converter<Converter>> converter = this.overall.getConverter(propertyType);
        if (!converter.isPresent() && propertyType.isAssignableFrom(String.class)) {
            return Optional.of(propertyType.cast(rawValue));
        }
        return converter.map(c -> c.convert(rawValue));
    }

    @Override
    public Iterable<String> getPropertyNames() {
        String prefix = this.prefix + this.name + ".";
        if (this.name.contains(".")) {
            prefix = this.prefix + "\"" + this.name + "\".";
        }
        String prefixAlpha = this.toAlpha(prefix);
        String prefixAlphaUpper = prefixAlpha.toUpperCase();
        String connectorPrefix = "mp.messaging.connector." + this.connector + ".";
        String connectorPrefixAlpha = this.toAlpha(connectorPrefix);
        String connectorPrefixAlphaUpper = connectorPrefixAlpha.toUpperCase();
        HashSet<String> names = new HashSet<String>();
        for (String name : this.overall.getPropertyNames()) {
            String computed;
            if (name.startsWith(connectorPrefix)) {
                computed = name.substring(connectorPrefix.length());
                names.add(computed);
                continue;
            }
            if (name.startsWith(connectorPrefixAlpha)) {
                computed = name.substring(connectorPrefixAlpha.length());
                if (!this.nameExists(connectorPrefix + computed)) continue;
                names.add(computed);
                continue;
            }
            if (name.startsWith(connectorPrefixAlphaUpper)) {
                computed = name.substring(connectorPrefixAlphaUpper.length());
                if (!this.nameExists(connectorPrefix + computed)) continue;
                names.add(computed);
                continue;
            }
            if (name.startsWith(prefix)) {
                computed = name.substring(prefix.length());
                names.add(computed);
                continue;
            }
            if (name.startsWith(prefixAlpha)) {
                computed = name.substring(prefixAlpha.length());
                if (!this.nameExists(prefix + computed)) continue;
                names.add(computed);
                continue;
            }
            if (!name.startsWith(prefixAlphaUpper)) continue;
            computed = name.substring(prefixAlphaUpper.length());
            if (!this.nameExists(prefix + computed)) continue;
            names.add(computed);
        }
        names.add("channel-name");
        return names;
    }

    private String toAlpha(String key) {
        return NON_ALPHA.matcher(key).replaceAll("_");
    }

    private boolean nameExists(String name) {
        return this.overall.getConfigValue(name).getRawValue() != null;
    }

    @Override
    public Iterable<ConfigSource> getConfigSources() {
        return this.overall.getConfigSources();
    }

    @Override
    public <T> Optional<Converter<T>> getConverter(Class<T> forType) {
        return this.overall.getConverter(forType);
    }

    @Override
    public <T> T unwrap(Class<T> type) {
        if (type.isInstance(this)) {
            return type.cast(this);
        }
        throw ProviderExceptions.ex.configNotOfType(type);
    }

    private static class ConfigValueImpl
    implements ConfigValue {
        private final String name;
        private final String value;

        public ConfigValueImpl(String name, String value) {
            this.name = name;
            this.value = value;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public String getRawValue() {
            return this.value;
        }

        @Override
        public String getSourceName() {
            return "ConnectorConfig internal";
        }

        @Override
        public int getSourceOrdinal() {
            return 0;
        }
    }
}

