/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.api.query;

import java.util.Arrays;
import java.util.List;
import org.kie.kogito.persistence.api.query.AttributeFilter;
import org.kie.kogito.persistence.api.query.AttributeSort;
import org.kie.kogito.persistence.api.query.FilterCondition;
import org.kie.kogito.persistence.api.query.SortDirection;

public final class QueryFilterFactory {
    private QueryFilterFactory() {
    }

    public static AttributeSort orderBy(String attribute, SortDirection sort) {
        return new AttributeSort(attribute, sort);
    }

    public static AttributeFilter<String> like(String attribute, String value) {
        return new AttributeFilter<String>(attribute, FilterCondition.LIKE, value);
    }

    public static AttributeFilter<String> contains(String attribute, String value) {
        return new AttributeFilter<String>(attribute, FilterCondition.CONTAINS, value);
    }

    public static <T> AttributeFilter<List<T>> in(String attribute, List<T> values) {
        return new AttributeFilter<List<T>>(attribute, FilterCondition.IN, values);
    }

    public static AttributeFilter<List<String>> containsAny(String attribute, List<String> values) {
        return new AttributeFilter<List<String>>(attribute, FilterCondition.CONTAINS_ANY, values);
    }

    public static AttributeFilter<List<String>> containsAll(String attribute, List<String> values) {
        return new AttributeFilter<List<String>>(attribute, FilterCondition.CONTAINS_ALL, values);
    }

    public static <T> AttributeFilter<T> greaterThan(String attribute, T value) {
        return new AttributeFilter<T>(attribute, FilterCondition.GT, value);
    }

    public static <T> AttributeFilter<T> greaterThanEqual(String attribute, T value) {
        return new AttributeFilter<T>(attribute, FilterCondition.GTE, value);
    }

    public static <T> AttributeFilter<T> lessThanEqual(String attribute, T value) {
        return new AttributeFilter<T>(attribute, FilterCondition.LTE, value);
    }

    public static <T> AttributeFilter<T> lessThan(String attribute, T value) {
        return new AttributeFilter<T>(attribute, FilterCondition.LT, value);
    }

    public static <T> AttributeFilter<T> equalTo(String attribute, T value) {
        return new AttributeFilter<T>(attribute, FilterCondition.EQUAL, value);
    }

    public static AttributeFilter<Object> isNull(String attribute) {
        return new AttributeFilter<Object>(attribute, FilterCondition.IS_NULL, null);
    }

    public static AttributeFilter<Object> notNull(String attribute) {
        return new AttributeFilter<Object>(attribute, FilterCondition.NOT_NULL, null);
    }

    public static <T> AttributeFilter<List<T>> between(String attribute, T from, T to) {
        return new AttributeFilter<List<T>>(attribute, FilterCondition.BETWEEN, Arrays.asList(from, to));
    }

    public static AttributeFilter<List<AttributeFilter>> or(List<AttributeFilter<?>> filters) {
        return new AttributeFilter<List<AttributeFilter>>(null, FilterCondition.OR, filters);
    }

    public static AttributeFilter<List<AttributeFilter>> and(List<AttributeFilter<?>> filters) {
        return new AttributeFilter<List<AttributeFilter>>(null, FilterCondition.AND, filters);
    }

    public static <T> AttributeFilter<AttributeFilter<T>> not(AttributeFilter<T> filter) {
        return new AttributeFilter<AttributeFilter<T>>(null, FilterCondition.NOT, filter);
    }
}

