/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.validator.runtime.jaxrs;

import io.quarkus.hibernate.validator.runtime.interceptor.AbstractMethodValidationInterceptor;
import io.quarkus.hibernate.validator.runtime.jaxrs.JaxrsEndPointValidated;
import io.quarkus.hibernate.validator.runtime.jaxrs.ResteasyConfigSupport;
import io.quarkus.hibernate.validator.runtime.jaxrs.ResteasyViolationExceptionImpl;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.interceptor.AroundConstruct;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import javax.validation.ConstraintViolationException;
import javax.ws.rs.core.MediaType;
import org.jboss.resteasy.util.MediaTypeHelper;

@JaxrsEndPointValidated
@Interceptor
@Priority(value=4800)
public class JaxrsEndPointValidationInterceptor
extends AbstractMethodValidationInterceptor {
    private static final List<MediaType> JSON_MEDIA_TYPE_LIST = Collections.singletonList(MediaType.APPLICATION_JSON_TYPE);
    @Inject
    ResteasyConfigSupport resteasyConfigSupport;

    @Override
    @AroundInvoke
    public Object validateMethodInvocation(InvocationContext ctx) throws Exception {
        try {
            return super.validateMethodInvocation(ctx);
        }
        catch (ConstraintViolationException e) {
            throw new ResteasyViolationExceptionImpl(e.getConstraintViolations(), this.getProduces(ctx.getMethod()));
        }
    }

    @Override
    @AroundConstruct
    public void validateConstructorInvocation(InvocationContext ctx) throws Exception {
        super.validateConstructorInvocation(ctx);
    }

    private List<MediaType> getProduces(Method method) {
        MediaType[] producedMediaTypes = MediaTypeHelper.getProduces(method.getDeclaringClass(), method);
        if (producedMediaTypes == null) {
            if (this.resteasyConfigSupport.isJsonDefault()) {
                return JSON_MEDIA_TYPE_LIST;
            }
            return Collections.emptyList();
        }
        return Arrays.asList(producedMediaTypes);
    }
}

