/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.helpers.BlockingIterable;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.AbstractMulti;
import io.smallrye.mutiny.subscription.Cancellable;
import io.smallrye.mutiny.subscription.CancellableSubscriber;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import io.smallrye.mutiny.subscription.Subscribers;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class MultiSubscribe<T> {
    private final AbstractMulti<T> upstream;

    public MultiSubscribe(AbstractMulti<T> upstream) {
        this.upstream = ParameterValidation.nonNull(upstream, "upstream");
    }

    public <S extends Subscriber<? super T>> S withSubscriber(S subscriber) {
        Subscriber<T> actual = Infrastructure.onMultiSubscription(this.upstream, subscriber);
        this.upstream.subscribe(actual);
        return subscriber;
    }

    public <S extends MultiSubscriber<? super T>> S withSubscriber(S subscriber) {
        this.upstream.subscribe(subscriber);
        return subscriber;
    }

    public Cancellable with(Consumer<? super Subscription> onSubscription, Consumer<? super T> onItem, Consumer<? super Throwable> onFailure, Runnable onComplete) {
        CancellableSubscriber<? super T> subscriber = Subscribers.from(ParameterValidation.nonNull(onItem, "onItem"), ParameterValidation.nonNull(onFailure, "onFailure"), ParameterValidation.nonNull(onComplete, "onComplete"), ParameterValidation.nonNull(onSubscription, "onSubscription"));
        return this.withSubscriber(subscriber);
    }

    public Cancellable with(Consumer<? super T> onItem, Consumer<? super Throwable> onFailure, Runnable onComplete) {
        ParameterValidation.nonNull(onItem, "onItem");
        ParameterValidation.nonNull(onFailure, "onFailure");
        ParameterValidation.nonNull(onComplete, "onComplete");
        CancellableSubscriber<? super T> subscriber = Subscribers.from(ParameterValidation.nonNull(onItem, "onItem"), ParameterValidation.nonNull(onFailure, "onFailure"), ParameterValidation.nonNull(onComplete, "onComplete"), s -> s.request(Long.MAX_VALUE));
        return this.withSubscriber(subscriber);
    }

    public Cancellable with(Consumer<? super T> onItem, Consumer<? super Throwable> onFailure) {
        ParameterValidation.nonNull(onItem, "onItem");
        ParameterValidation.nonNull(onFailure, "onFailure");
        CancellableSubscriber<? super T> subscriber = Subscribers.from(ParameterValidation.nonNull(onItem, "onItem"), ParameterValidation.nonNull(onFailure, "onFailure"), null, s -> s.request(Long.MAX_VALUE));
        return this.withSubscriber(subscriber);
    }

    public Cancellable with(Consumer<? super T> onItem) {
        Consumer<? super T> actual = Infrastructure.decorate(ParameterValidation.nonNull(onItem, "onItem"));
        CancellableSubscriber<? super T> subscriber = Subscribers.from(actual, Subscribers.NO_ON_FAILURE, null, s -> s.request(Long.MAX_VALUE));
        return this.withSubscriber(subscriber);
    }

    public Cancellable with(Consumer<? super T> onItem, Runnable onComplete) {
        ParameterValidation.nonNull(onItem, "onItem");
        ParameterValidation.nonNull(onComplete, "onComplete");
        CancellableSubscriber<? super T> subscriber = Subscribers.from(ParameterValidation.nonNull(onItem, "onItem"), null, onComplete, s -> s.request(Long.MAX_VALUE));
        return this.withSubscriber(subscriber);
    }

    @CheckReturnValue
    public BlockingIterable<T> asIterable() {
        return this.asIterable(256, () -> new ArrayBlockingQueue(256));
    }

    @CheckReturnValue
    public BlockingIterable<T> asIterable(int batchSize, Supplier<Queue<T>> supplier) {
        return new BlockingIterable<T>(this.upstream, batchSize, supplier);
    }

    @CheckReturnValue
    public Stream<T> asStream() {
        return this.asStream(256, () -> new ArrayBlockingQueue(256));
    }

    @CheckReturnValue
    public Stream<T> asStream(int batchSize, Supplier<Queue<T>> supplier) {
        return this.asIterable(batchSize, supplier).stream();
    }
}

