/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.converters.UniConverter;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.uni.UniNever;
import io.smallrye.mutiny.operators.uni.builders.UniCreateFromCompletionStage;
import io.smallrye.mutiny.operators.uni.builders.UniCreateFromCompletionStageWithState;
import io.smallrye.mutiny.operators.uni.builders.UniCreateFromDeferredSupplier;
import io.smallrye.mutiny.operators.uni.builders.UniCreateFromDeferredSupplierWithState;
import io.smallrye.mutiny.operators.uni.builders.UniCreateFromEmitterWithState;
import io.smallrye.mutiny.operators.uni.builders.UniCreateFromFailureSupplier;
import io.smallrye.mutiny.operators.uni.builders.UniCreateFromFuture;
import io.smallrye.mutiny.operators.uni.builders.UniCreateFromItemSupplier;
import io.smallrye.mutiny.operators.uni.builders.UniCreateFromItemWithState;
import io.smallrye.mutiny.operators.uni.builders.UniCreateFromKnownFailure;
import io.smallrye.mutiny.operators.uni.builders.UniCreateFromKnownItem;
import io.smallrye.mutiny.operators.uni.builders.UniCreateFromPublisher;
import io.smallrye.mutiny.operators.uni.builders.UniCreateWithEmitter;
import io.smallrye.mutiny.subscription.UniEmitter;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;

public class UniCreate {
    public static final UniCreate INSTANCE = new UniCreate();
    private static final Uni UNI_OF_NULL = Uni.createFrom().item((Object)null);

    private UniCreate() {
    }

    @CheckReturnValue
    public <I, T> Uni<T> converter(UniConverter<I, T> converter, I instance) {
        return converter.from(instance);
    }

    @CheckReturnValue
    public <T> Uni<T> completionStage(CompletionStage<? extends T> stage) {
        CompletionStage actual = ParameterValidation.nonNull(stage, "stage");
        return this.completionStage(() -> actual);
    }

    @CheckReturnValue
    public <T, S> Uni<T> completionStage(Supplier<S> stateSupplier, Function<S, ? extends CompletionStage<? extends T>> mapper) {
        Supplier<S> actualStateSupplier = Infrastructure.decorate(ParameterValidation.nonNull(stateSupplier, "stateSupplier"));
        Function<S, ? extends CompletionStage<? extends T>> actualMapper = Infrastructure.decorate(ParameterValidation.nonNull(mapper, "mapper"));
        return Infrastructure.onUniCreation(new UniCreateFromCompletionStageWithState(actualStateSupplier, actualMapper));
    }

    @CheckReturnValue
    public <T> Uni<T> completionStage(Supplier<? extends CompletionStage<? extends T>> supplier) {
        Supplier<? extends CompletionStage<? extends T>> actual = Infrastructure.decorate(ParameterValidation.nonNull(supplier, "supplier"));
        return Infrastructure.onUniCreation(new UniCreateFromCompletionStage(actual));
    }

    @CheckReturnValue
    public <T> Uni<T> future(Future<? extends T> future) {
        Future actual = ParameterValidation.nonNull(future, "future");
        return new UniCreateFromFuture(() -> actual);
    }

    @CheckReturnValue
    public <T> Uni<T> future(Supplier<Future<? extends T>> supplier) {
        Supplier<Future<? extends T>> actual = Infrastructure.decorate(ParameterValidation.nonNull(supplier, "supplier"));
        return new UniCreateFromFuture<T>(actual);
    }

    @CheckReturnValue
    public <T> Uni<T> publisher(Publisher<? extends T> publisher) {
        Publisher<? extends T> actual = ParameterValidation.nonNull(publisher, "publisher");
        return Infrastructure.onUniCreation(new UniCreateFromPublisher<T>(actual));
    }

    @CheckReturnValue
    public <T> Uni<T> item(Supplier<? extends T> supplier) {
        Supplier<? extends T> actual = Infrastructure.decorate(ParameterValidation.nonNull(supplier, "supplier"));
        return Infrastructure.onUniCreation(new UniCreateFromItemSupplier<T>(actual));
    }

    @CheckReturnValue
    public <T, S> Uni<T> item(Supplier<S> stateSupplier, Function<S, ? extends T> mapper) {
        Supplier<S> actualSupplier = Infrastructure.decorate(ParameterValidation.nonNull(stateSupplier, "stateSupplier"));
        Function<S, ? extends T> actualMapper = Infrastructure.decorate(ParameterValidation.nonNull(mapper, "mapper"));
        return Infrastructure.onUniCreation(new UniCreateFromItemWithState<T, S>(actualSupplier, actualMapper));
    }

    @CheckReturnValue
    public <T> Uni<T> item(T item) {
        return Infrastructure.onUniCreation(new UniCreateFromKnownItem<T>(item));
    }

    @CheckReturnValue
    public Uni<Void> voidItem() {
        return this.nullItem();
    }

    @CheckReturnValue
    public <T> Uni<T> nullItem() {
        return UNI_OF_NULL;
    }

    @CheckReturnValue
    public <T> Uni<T> optional(Optional<T> optional) {
        Optional actual = ParameterValidation.nonNull(optional, "optional");
        return this.optional(() -> actual);
    }

    @CheckReturnValue
    public <T> Uni<T> optional(Supplier<Optional<T>> supplier) {
        Supplier actual = Infrastructure.decorate(ParameterValidation.nonNull(supplier, "supplier"));
        return this.item((T)((Supplier<Object>)() -> ((Optional)actual.get()).orElse(null)));
    }

    @CheckReturnValue
    public <T> Uni<T> emitter(Consumer<UniEmitter<? super T>> consumer) {
        Consumer<UniEmitter<? super T>> actual = Infrastructure.decorate(ParameterValidation.nonNull(consumer, "consumer"));
        return Infrastructure.onUniCreation(new UniCreateWithEmitter<T>(actual));
    }

    @CheckReturnValue
    public <T, S> Uni<T> emitter(Supplier<S> stateSupplier, BiConsumer<S, UniEmitter<? super T>> consumer) {
        BiConsumer<S, UniEmitter<? super T>> actual = Infrastructure.decorate(ParameterValidation.nonNull(consumer, "consumer"));
        Supplier<S> supplier = Infrastructure.decorate(ParameterValidation.nonNull(stateSupplier, "stateSupplier"));
        return Infrastructure.onUniCreation(new UniCreateFromEmitterWithState<T, S>(supplier, actual));
    }

    @CheckReturnValue
    public <T> Uni<T> deferred(Supplier<Uni<? extends T>> supplier) {
        Supplier<Uni<? extends T>> actual = Infrastructure.decorate(ParameterValidation.nonNull(supplier, "supplier"));
        return Infrastructure.onUniCreation(new UniCreateFromDeferredSupplier<T>(actual));
    }

    @CheckReturnValue
    public <T, S> Uni<T> deferred(Supplier<S> stateSupplier, Function<S, Uni<? extends T>> mapper) {
        Supplier<S> actualSupplier = Infrastructure.decorate(ParameterValidation.nonNull(stateSupplier, "stateSupplier"));
        Function<S, Uni<? extends T>> actualProducer = Infrastructure.decorate(ParameterValidation.nonNull(mapper, "mapper"));
        return Infrastructure.onUniCreation(new UniCreateFromDeferredSupplierWithState<S, T>(actualSupplier, actualProducer));
    }

    @CheckReturnValue
    public <T> Uni<T> failure(Throwable failure) {
        return Infrastructure.onUniCreation(new UniCreateFromKnownFailure(ParameterValidation.nonNull(failure, "failure")));
    }

    @CheckReturnValue
    public <T> Uni<T> failure(Supplier<Throwable> supplier) {
        Supplier<Throwable> actual = Infrastructure.decorate(ParameterValidation.nonNull(supplier, "supplier"));
        return Infrastructure.onUniCreation(new UniCreateFromFailureSupplier(actual));
    }

    @CheckReturnValue
    public <T> Uni<T> nothing() {
        return UniNever.INSTANCE;
    }

    @CheckReturnValue
    public <T> Uni<T> multi(Multi<T> multi) {
        ParameterValidation.nonNull(multi, "multi");
        return multi.toUni();
    }
}

