/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.uni.builders;

import io.smallrye.mutiny.CompositeException;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class UniJoinAll<T>
extends AbstractUni<List<T>> {
    private final List<Uni<T>> unis;
    private final Mode mode;

    public UniJoinAll(List<Uni<T>> unis, Mode mode) {
        this.unis = unis;
        this.mode = mode;
    }

    @Override
    public void subscribe(UniSubscriber<? super List<T>> subscriber) {
        UniJoinAllSubscription joinAllSubscription = new UniJoinAllSubscription(subscriber);
        subscriber.onSubscribe(joinAllSubscription);
        joinAllSubscription.triggerSubscriptions();
    }

    private class UniJoinAllSubscription
    implements UniSubscription {
        private final UniSubscriber<? super List<T>> subscriber;
        private final AtomicReferenceArray<UniSubscription> subscriptions;
        private final AtomicBoolean cancelled;
        private final AtomicReferenceArray<T> items;
        private final List<Throwable> failures;
        private final AtomicInteger signalsCount;

        public UniJoinAllSubscription(UniSubscriber<? super List<T>> subscriber) {
            this.subscriptions = new AtomicReferenceArray(UniJoinAll.this.unis.size());
            this.cancelled = new AtomicBoolean();
            this.items = new AtomicReferenceArray(UniJoinAll.this.unis.size());
            this.failures = Collections.synchronizedList(new ArrayList());
            this.signalsCount = new AtomicInteger();
            this.subscriber = subscriber;
        }

        public void triggerSubscriptions() {
            for (int i = 0; i < UniJoinAll.this.unis.size() && !this.cancelled.get(); ++i) {
                int index = i;
                Uni uni = (Uni)UniJoinAll.this.unis.get(i);
                uni.onSubscription().invoke(subscription -> this.subscriptions.set(index, (UniSubscription)subscription)).subscribe().with(item -> this.onItem(index, item), this::onFailure);
            }
        }

        @Override
        public void cancel() {
            this.cancelled.set(true);
            this.cancelSubscriptions();
        }

        private void cancelSubscriptions() {
            for (int i = 0; i < UniJoinAll.this.unis.size(); ++i) {
                UniSubscription sub = this.subscriptions.get(i);
                if (sub == null) continue;
                sub.cancel();
            }
        }

        private void onItem(int index, T item) {
            if (!this.cancelled.get()) {
                this.items.set(index, item);
                this.forwardSignalWhenComplete();
            }
        }

        private void forwardSignalWhenComplete() {
            if (this.signalsCount.incrementAndGet() == UniJoinAll.this.unis.size()) {
                this.cancelled.set(true);
                if (this.failures.isEmpty()) {
                    ArrayList result = new ArrayList(UniJoinAll.this.unis.size());
                    for (int i = 0; i < UniJoinAll.this.unis.size(); ++i) {
                        result.add(this.items.get(i));
                    }
                    this.subscriber.onItem(result);
                } else {
                    this.subscriber.onFailure(new CompositeException(this.failures));
                }
            }
        }

        private void onFailure(Throwable failure) {
            switch (UniJoinAll.this.mode) {
                case COLLECT_FAILURES: {
                    if (!this.cancelled.get()) {
                        this.failures.add(failure);
                        this.forwardSignalWhenComplete();
                        break;
                    }
                    Infrastructure.handleDroppedException(failure);
                    break;
                }
                case FAIL_FAST: {
                    if (this.cancelled.compareAndSet(false, true)) {
                        this.cancelSubscriptions();
                        this.subscriber.onFailure(failure);
                        break;
                    }
                    Infrastructure.handleDroppedException(failure);
                }
            }
        }
    }

    public static enum Mode {
        COLLECT_FAILURES,
        FAIL_FAST;

    }
}

