/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.api.models;

import io.smallrye.openapi.api.models.ExtensibleImpl;
import io.smallrye.openapi.api.models.ModelImpl;
import io.smallrye.openapi.runtime.util.ModelUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.ExternalDocumentation;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.callbacks.Callback;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.eclipse.microprofile.openapi.models.responses.APIResponses;
import org.eclipse.microprofile.openapi.models.security.SecurityRequirement;
import org.eclipse.microprofile.openapi.models.servers.Server;

public class OperationImpl
extends ExtensibleImpl<Operation>
implements Operation,
ModelImpl {
    private List<String> tags;
    private String summary;
    private String description;
    private ExternalDocumentation externalDocs;
    private String operationId;
    private List<Parameter> parameters;
    private RequestBody requestBody;
    private APIResponses responses;
    private Map<String, Callback> callbacks;
    private Boolean deprecated;
    private List<SecurityRequirement> security;
    private List<Server> servers;
    private String methodRef;

    public OperationImpl() {
    }

    public OperationImpl(String methodRef) {
        this.methodRef = methodRef;
    }

    @Override
    public List<String> getTags() {
        return ModelUtil.unmodifiableList(this.tags);
    }

    @Override
    public void setTags(List<String> tags) {
        this.tags = ModelUtil.replace(tags, ArrayList::new);
    }

    @Override
    public Operation addTag(String tag) {
        this.tags = ModelUtil.add(tag, this.tags, ArrayList::new);
        return this;
    }

    @Override
    public void removeTag(String tag) {
        ModelUtil.remove(this.tags, tag);
    }

    @Override
    public String getSummary() {
        return this.summary;
    }

    @Override
    public void setSummary(String summary) {
        this.summary = summary;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public ExternalDocumentation getExternalDocs() {
        return this.externalDocs;
    }

    @Override
    public void setExternalDocs(ExternalDocumentation externalDocs) {
        this.externalDocs = externalDocs;
    }

    @Override
    public String getOperationId() {
        return this.operationId;
    }

    @Override
    public void setOperationId(String operationId) {
        this.operationId = operationId;
    }

    @Override
    public List<Parameter> getParameters() {
        return ModelUtil.unmodifiableList(this.parameters);
    }

    @Override
    public void setParameters(List<Parameter> parameters) {
        this.parameters = ModelUtil.replace(parameters, ArrayList::new);
    }

    @Override
    public Operation addParameter(Parameter parameter) {
        this.parameters = ModelUtil.add(parameter, this.parameters, ArrayList::new);
        return this;
    }

    @Override
    public void removeParameter(Parameter parameter) {
        ModelUtil.remove(this.parameters, parameter);
    }

    @Override
    public RequestBody getRequestBody() {
        return this.requestBody;
    }

    @Override
    public void setRequestBody(RequestBody requestBody) {
        this.requestBody = requestBody;
    }

    @Override
    public APIResponses getResponses() {
        return this.responses;
    }

    @Override
    public void setResponses(APIResponses responses) {
        this.responses = responses;
    }

    @Override
    public Map<String, Callback> getCallbacks() {
        return ModelUtil.unmodifiableMap(this.callbacks);
    }

    @Override
    public void setCallbacks(Map<String, Callback> callbacks) {
        this.callbacks = ModelUtil.replace(callbacks, LinkedHashMap::new);
    }

    @Override
    public Operation addCallback(String key, Callback callback) {
        this.callbacks = ModelUtil.add(key, callback, this.callbacks, LinkedHashMap::new);
        return this;
    }

    @Override
    public void removeCallback(String key) {
        ModelUtil.remove(this.callbacks, key);
    }

    @Override
    public Boolean getDeprecated() {
        return this.deprecated;
    }

    @Override
    public void setDeprecated(Boolean deprecated) {
        this.deprecated = deprecated;
    }

    @Override
    public List<SecurityRequirement> getSecurity() {
        return ModelUtil.unmodifiableList(this.security);
    }

    @Override
    public void setSecurity(List<SecurityRequirement> security) {
        this.security = ModelUtil.replace(security, ArrayList::new);
    }

    @Override
    public Operation addSecurityRequirement(SecurityRequirement securityRequirement) {
        this.security = ModelUtil.add(securityRequirement, this.security, ArrayList::new);
        return this;
    }

    @Override
    public void removeSecurityRequirement(SecurityRequirement securityRequirement) {
        ModelUtil.remove(this.security, securityRequirement);
    }

    @Override
    public List<Server> getServers() {
        return ModelUtil.unmodifiableList(this.servers);
    }

    @Override
    public void setServers(List<Server> servers) {
        this.servers = ModelUtil.replace(servers, ArrayList::new);
    }

    @Override
    public Operation addServer(Server server) {
        this.servers = ModelUtil.add(server, this.servers, ArrayList::new);
        return this;
    }

    @Override
    public void removeServer(Server server) {
        ModelUtil.remove(this.servers, server);
    }

    public String getMethodRef() {
        return this.methodRef;
    }

    public void setMethodRef(String methodRef) {
        this.methodRef = methodRef;
    }
}

