/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.providers.connectors;

import io.smallrye.reactive.messaging.providers.i18n.ProviderLogging;
import io.vertx.mutiny.core.Vertx;
import javax.annotation.Priority;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.BeforeDestroyed;
import javax.enterprise.event.Observes;
import javax.enterprise.event.Reception;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;

@ApplicationScoped
public class ExecutionHolder {
    private boolean internalVertxInstance = false;
    final Vertx vertx;

    public void terminate(@Observes(notifyObserver=Reception.IF_EXISTS) @Priority(value=200) @BeforeDestroyed(value=ApplicationScoped.class) Object event) {
        if (this.internalVertxInstance) {
            this.vertx.close().await().indefinitely();
        }
    }

    public ExecutionHolder() {
        this.vertx = null;
    }

    public ExecutionHolder(Vertx vertx) {
        this.vertx = vertx;
        this.internalVertxInstance = true;
    }

    @Inject
    public ExecutionHolder(Instance<Vertx> instanceOfVertx) {
        if (instanceOfVertx == null || instanceOfVertx.isUnsatisfied()) {
            this.internalVertxInstance = true;
            this.vertx = Vertx.vertx();
            ProviderLogging.log.vertXInstanceCreated();
        } else {
            this.vertx = (Vertx)instanceOfVertx.get();
        }
    }

    public Vertx vertx() {
        return this.vertx;
    }
}

