/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.api.schema;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.kie.kogito.persistence.api.schema.EntityIndexDescriptor;
import org.kie.kogito.persistence.api.schema.ProcessDescriptor;

public class SchemaDescriptor {
    String name;
    String schemaContent;
    Map<String, EntityIndexDescriptor> entityIndexDescriptors;
    ProcessDescriptor processDescriptor;

    public SchemaDescriptor(String name, String schemaContent, Map<String, EntityIndexDescriptor> entityIndexDescriptors, ProcessDescriptor processDescriptor) {
        this.name = name;
        this.schemaContent = schemaContent;
        this.entityIndexDescriptors = entityIndexDescriptors;
        this.processDescriptor = processDescriptor;
    }

    public String getName() {
        return this.name;
    }

    public String getSchemaContent() {
        return this.schemaContent;
    }

    public Map<String, EntityIndexDescriptor> getEntityIndexDescriptors() {
        return this.entityIndexDescriptors;
    }

    public Optional<ProcessDescriptor> getProcessDescriptor() {
        return Optional.ofNullable(this.processDescriptor);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaDescriptor that = (SchemaDescriptor)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.schemaContent, that.schemaContent) && Objects.equals(this.entityIndexDescriptors, that.entityIndexDescriptors) && Objects.equals(this.processDescriptor, that.processDescriptor);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.schemaContent, this.entityIndexDescriptors, this.processDescriptor);
    }

    public String toString() {
        return "SchemaDescriptor{name='" + this.name + "', schemaContent='" + this.schemaContent + "', entityIndexDescriptors=" + this.entityIndexDescriptors + ", processDescriptor=" + this.processDescriptor + "}";
    }
}

