/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.infinispan.cache;

import io.quarkus.arc.properties.IfBuildProperty;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.RemoteCacheManagerAdmin;
import org.infinispan.commons.dataconversion.MediaType;
import org.kie.kogito.persistence.api.Storage;
import org.kie.kogito.persistence.api.StorageService;
import org.kie.kogito.persistence.infinispan.cache.InfinispanStorage;
import org.kie.kogito.persistence.infinispan.cache.JsonDataFormatMarshaller;
import org.kie.kogito.persistence.infinispan.cache.KogitoCacheDefaultConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@IfBuildProperty(name="kogito.persistence.type", stringValue="infinispan")
public class InfinispanStorageService
implements StorageService {
    private static final Logger LOGGER = LoggerFactory.getLogger(InfinispanStorageService.class);
    @Inject
    JsonDataFormatMarshaller marshaller;
    DataFormat jsonDataFormat;
    @Inject
    @ConfigProperty(name="kogito.cache.domain.template")
    Optional<String> cacheTemplateName;
    @Inject
    RemoteCacheManager manager;

    @PostConstruct
    public void init() {
        this.jsonDataFormat = DataFormat.builder().valueType(MediaType.APPLICATION_JSON).valueMarshaller(this.marshaller).build();
        this.manager.start();
    }

    @PreDestroy
    public void destroy() {
        this.manager.stop();
        try {
            this.manager.close();
        }
        catch (Exception ex) {
            LOGGER.warn("Error trying to close Infinispan remote cache manager", ex);
        }
    }

    protected <K, V> RemoteCache<K, V> getOrCreateCache(String name) {
        LOGGER.debug("Trying to get cache {} from the server", (Object)name);
        RemoteCache<K, V> remoteCache = this.manager.getCache(name);
        return remoteCache == null ? this.createCache(name) : remoteCache;
    }

    protected <K, V> RemoteCache<K, V> createCache(String name) {
        RemoteCacheManagerAdmin admin = this.manager.administration();
        if (this.cacheTemplateName.isPresent()) {
            LOGGER.debug("Creating cache {} based on template named {}", (Object)name, (Object)this.cacheTemplateName.get());
            return admin.createCache(name, this.cacheTemplateName.get());
        }
        LOGGER.debug("Creating cache {} based on Kogito default configuration", (Object)name);
        return admin.createCache(name, new KogitoCacheDefaultConfiguration(name));
    }

    @Override
    public Storage<String, String> getCache(String name) {
        return new InfinispanStorage<String, String>(this.getOrCreateCache(name), String.class.getName());
    }

    @Override
    public <T> Storage<String, T> getCache(String name, Class<T> type) {
        return new InfinispanStorage(this.getOrCreateCache(name), type.getName());
    }

    @Override
    public <T> Storage<String, T> getCache(String name, Class<T> type, String rootType) {
        return new InfinispanStorage(this.getOrCreateCache(name).withDataFormat(this.jsonDataFormat), rootType);
    }
}

