/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.service.common.messaging.incoming;

import java.util.List;
import java.util.stream.Collectors;
import org.kie.kogito.explainability.api.NamedTypedValue;
import org.kie.kogito.tracing.decision.event.message.Message;
import org.kie.kogito.tracing.decision.event.message.MessageLevel;
import org.kie.kogito.tracing.decision.event.trace.TraceEvent;
import org.kie.kogito.tracing.decision.event.trace.TraceInputValue;
import org.kie.kogito.tracing.decision.event.trace.TraceOutputValue;
import org.kie.kogito.tracing.typedvalue.TypedValue;
import org.kie.kogito.trusty.storage.api.model.Decision;
import org.kie.kogito.trusty.storage.api.model.DecisionInput;
import org.kie.kogito.trusty.storage.api.model.DecisionOutcome;

public class TraceEventConverter {
    private TraceEventConverter() {
    }

    public static Decision toDecision(TraceEvent event, String sourceUrl, String serviceUrl) {
        List<DecisionInput> inputs = event.getInputs() == null ? null : event.getInputs().stream().map(TraceEventConverter::toInput).collect(Collectors.toList());
        List<DecisionOutcome> outcomes = event.getOutputs() == null ? null : event.getOutputs().stream().map(TraceEventConverter::toOutcome).collect(Collectors.toList());
        return new Decision(event.getHeader().getExecutionId(), sourceUrl, serviceUrl, event.getHeader().getStartTimestamp(), TraceEventConverter.decisionHasSucceeded(event.getOutputs()), null, event.getHeader().getResourceId().getModelName(), event.getHeader().getResourceId().getModelNamespace(), inputs, outcomes);
    }

    public static DecisionInput toInput(TraceInputValue eventInput) {
        return new DecisionInput(eventInput.getId(), eventInput.getName(), eventInput.getValue());
    }

    public static DecisionOutcome toOutcome(TraceOutputValue eventOutput) {
        List<NamedTypedValue> flattenedInputs = eventOutput.getInputs().entrySet().stream().map(i -> new NamedTypedValue((String)i.getKey(), (TypedValue)i.getValue())).collect(Collectors.toList());
        return new DecisionOutcome(eventOutput.getId(), eventOutput.getName(), eventOutput.getStatus(), eventOutput.getValue(), flattenedInputs, eventOutput.getMessages());
    }

    public static boolean decisionHasSucceeded(List<TraceOutputValue> outputs) {
        return outputs != null && outputs.stream().noneMatch(o -> "failed".equalsIgnoreCase(o.getStatus()) || TraceEventConverter.messageListHasErrors(o.getMessages()));
    }

    private static boolean messageListHasErrors(List<Message> messages) {
        return messages != null && messages.stream().anyMatch(m -> m.getLevel() == MessageLevel.ERROR);
    }
}

