/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.service.common.responses;

import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import org.kie.kogito.trusty.service.common.responses.ExecutionHeaderResponse;
import org.kie.kogito.trusty.service.common.responses.ExecutionType;
import org.kie.kogito.trusty.storage.api.model.Execution;

public class ResponseUtils {
    private ResponseUtils() {
    }

    public static ExecutionHeaderResponse executionHeaderResponseFrom(Execution execution) {
        OffsetDateTime ldt = OffsetDateTime.ofInstant(Instant.ofEpochMilli(execution.getExecutionTimestamp()), ZoneOffset.UTC);
        return new ExecutionHeaderResponse(execution.getExecutionId(), ldt, execution.hasSucceeded(), execution.getExecutorName(), execution.getExecutedModelName(), execution.getExecutedModelNamespace(), ResponseUtils.executionTypeFrom(execution.getExecutionType()));
    }

    private static ExecutionType executionTypeFrom(org.kie.kogito.trusty.storage.api.model.ExecutionType executionType) {
        switch (executionType) {
            case DECISION: {
                return ExecutionType.DECISION;
            }
            case PROCESS: {
                return ExecutionType.PROCESS;
            }
        }
        throw new IllegalStateException();
    }
}

