/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.client.impl;

import io.netty.handler.codec.http.cookie.ClientCookieDecoder;
import io.netty.handler.codec.http.cookie.ClientCookieEncoder;
import io.netty.handler.codec.http.cookie.Cookie;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.RequestOptions;
import io.vertx.ext.web.client.impl.HttpContext;
import io.vertx.ext.web.client.impl.HttpRequestImpl;
import io.vertx.ext.web.client.impl.WebClientSessionAware;
import io.vertx.ext.web.client.spi.CookieStore;
import java.net.URI;
import java.util.List;

public class SessionAwareInterceptor
implements Handler<HttpContext<?>> {
    private final WebClientSessionAware parentClient;

    public SessionAwareInterceptor(WebClientSessionAware clientSessionAware) {
        this.parentClient = clientSessionAware;
    }

    @Override
    public void handle(HttpContext<?> context) {
        switch (context.phase()) {
            case CREATE_REQUEST: {
                this.createRequest(context);
                break;
            }
            case FOLLOW_REDIRECT: {
                this.processRedirectCookies(context);
                break;
            }
            case DISPATCH_RESPONSE: {
                this.processResponse(context);
                break;
            }
        }
        context.next();
    }

    private void createRequest(HttpContext<?> context) {
        Iterable<Cookie> cookies;
        String encodedCookies;
        HttpRequestImpl request = (HttpRequestImpl)context.request();
        RequestOptions requestOptions = context.requestOptions();
        MultiMap headers = requestOptions.getHeaders();
        if (headers == null) {
            headers = HttpHeaders.headers();
            requestOptions.setHeaders(headers);
        }
        headers.addAll(this.parentClient.headers());
        String domain = request.virtualHost();
        if (domain == null) {
            domain = request.host();
        }
        if ((encodedCookies = ClientCookieEncoder.STRICT.encode(cookies = this.parentClient.cookieStore().get(request.ssl, domain, request.uri))) != null) {
            headers.add(HttpHeaders.COOKIE, (CharSequence)encodedCookies);
        }
    }

    private void processRedirectCookies(HttpContext<?> context) {
        this.processRedirectResponse(context);
        this.prepareRedirectRequest(context);
    }

    private void processRedirectResponse(HttpContext<?> context) {
        List<String> cookieHeaders = context.clientResponse().cookies();
        if (cookieHeaders == null) {
            return;
        }
        HttpRequestImpl originalRequest = (HttpRequestImpl)context.request();
        CookieStore cookieStore = this.parentClient.cookieStore();
        String domain = URI.create(context.clientResponse().request().absoluteURI()).getHost();
        if (domain.equals(originalRequest.host()) && originalRequest.virtualHost != null) {
            domain = originalRequest.virtualHost;
        }
        String finalDomain = domain;
        cookieHeaders.forEach(header -> {
            Cookie cookie = ClientCookieDecoder.STRICT.decode((String)header);
            if (cookie != null) {
                if (cookie.domain() == null) {
                    cookie.setDomain(finalDomain);
                }
                cookieStore.put(cookie);
            }
        });
    }

    private void prepareRedirectRequest(HttpContext<?> context) {
        RequestOptions redirectRequest = context.requestOptions();
        HttpRequestImpl originalRequest = (HttpRequestImpl)context.request();
        String redirectHost = redirectRequest.getHost();
        String domain = redirectHost.equals(originalRequest.host()) && originalRequest.virtualHost != null ? originalRequest.virtualHost : redirectHost;
        String path = SessionAwareInterceptor.parsePath(redirectRequest.getURI());
        Iterable<Cookie> cookies = this.parentClient.cookieStore().get(originalRequest.ssl, domain, path);
        String encodedCookies = ClientCookieEncoder.STRICT.encode(cookies);
        if (encodedCookies != null) {
            redirectRequest.putHeader(HttpHeaders.COOKIE, (CharSequence)encodedCookies);
        }
    }

    private static String parsePath(String uri) {
        int i;
        if (uri.length() == 0) {
            return "";
        }
        if (uri.charAt(0) == '/') {
            i = 0;
        } else {
            i = uri.indexOf("://");
            if (i == -1) {
                i = 0;
            } else if ((i = uri.indexOf(47, i + 3)) == -1) {
                return "/";
            }
        }
        int queryStart = uri.indexOf(63, i);
        if (queryStart == -1) {
            queryStart = uri.length();
        }
        return uri.substring(i, queryStart);
    }

    private void processResponse(HttpContext<?> context) {
        List<String> cookieHeaders = context.response().cookies();
        if (cookieHeaders == null) {
            return;
        }
        HttpRequestImpl request = (HttpRequestImpl)context.request();
        CookieStore cookieStore = this.parentClient.cookieStore();
        cookieHeaders.forEach(header -> {
            Cookie cookie = ClientCookieDecoder.STRICT.decode((String)header);
            if (cookie != null) {
                if (cookie.domain() == null) {
                    cookie.setDomain(request.virtualHost != null ? request.virtualHost : request.host());
                }
                cookieStore.put(cookie);
            }
        });
    }
}

