/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.streams.operators.core;

import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.eclipse.microprofile.reactive.streams.operators.ProcessorBuilder;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreamsFactory;
import org.eclipse.microprofile.reactive.streams.operators.SubscriberBuilder;
import org.eclipse.microprofile.reactive.streams.operators.core.InternalStages;
import org.eclipse.microprofile.reactive.streams.operators.core.ProcessorBuilderImpl;
import org.eclipse.microprofile.reactive.streams.operators.core.PublisherBuilderImpl;
import org.eclipse.microprofile.reactive.streams.operators.core.ReactiveStreamsGraphBuilder;
import org.eclipse.microprofile.reactive.streams.operators.core.Stages;
import org.eclipse.microprofile.reactive.streams.operators.core.SubscriberBuilderImpl;
import org.eclipse.microprofile.reactive.streams.operators.spi.Graph;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public class ReactiveStreamsFactoryImpl
implements ReactiveStreamsFactory {
    @Override
    public <T> PublisherBuilder<T> fromPublisher(Publisher<? extends T> publisher) {
        return new PublisherBuilderImpl(new Stages.PublisherStage(publisher));
    }

    @Override
    public <T> PublisherBuilder<T> of(T t) {
        return new PublisherBuilderImpl(new Stages.Of(Collections.singletonList(Objects.requireNonNull(t, "Reactive Streams does not support null elements"))));
    }

    @Override
    public <T> PublisherBuilder<T> of(T ... ts) {
        return this.fromIterable(Arrays.asList(ts));
    }

    @Override
    public <T> PublisherBuilder<T> empty() {
        return new PublisherBuilderImpl(Stages.Of.EMPTY);
    }

    @Override
    public <T> PublisherBuilder<T> ofNullable(T t) {
        return t == null ? this.empty() : this.of(t);
    }

    @Override
    public <T> PublisherBuilder<T> fromIterable(Iterable<? extends T> ts) {
        return new PublisherBuilderImpl(new Stages.Of(ts));
    }

    @Override
    public <T> PublisherBuilder<T> failed(Throwable t) {
        return new PublisherBuilderImpl(new Stages.Failed(t));
    }

    @Override
    public <T> ProcessorBuilder<T, T> builder() {
        return new ProcessorBuilderImpl(InternalStages.Identity.INSTANCE, null);
    }

    @Override
    public <T, R> ProcessorBuilder<T, R> fromProcessor(Processor<? super T, ? extends R> processor) {
        return new ProcessorBuilderImpl(new Stages.ProcessorStage(processor), null);
    }

    @Override
    public <T> SubscriberBuilder<T, Void> fromSubscriber(Subscriber<? extends T> subscriber) {
        return new SubscriberBuilderImpl(new Stages.SubscriberStage(subscriber), null);
    }

    @Override
    public <T> PublisherBuilder<T> iterate(T seed, UnaryOperator<T> f) {
        Objects.requireNonNull(f, "Operator must not be null");
        return this.fromIterable(() -> Stream.iterate(seed, f).iterator());
    }

    @Override
    public <T> PublisherBuilder<T> generate(Supplier<? extends T> s) {
        Objects.requireNonNull(s, "Supplier must not be null");
        return this.fromIterable(() -> Stream.generate(s).iterator());
    }

    @Override
    public <T> PublisherBuilder<T> concat(PublisherBuilder<? extends T> a, PublisherBuilder<? extends T> b) {
        return new PublisherBuilderImpl(new Stages.Concat(ReactiveStreamsGraphBuilder.rsBuilderToGraph(a), ReactiveStreamsGraphBuilder.rsBuilderToGraph(b)));
    }

    @Override
    public <T> PublisherBuilder<T> fromCompletionStage(CompletionStage<? extends T> completionStage) {
        return new PublisherBuilderImpl(new Stages.FromCompletionStage(completionStage));
    }

    @Override
    public <T> PublisherBuilder<T> fromCompletionStageNullable(CompletionStage<? extends T> completionStage) {
        return new PublisherBuilderImpl(new Stages.FromCompletionStageNullable(completionStage));
    }

    @Override
    public <T, R> ProcessorBuilder<T, R> coupled(SubscriberBuilder<? super T, ?> subscriber, PublisherBuilder<? extends R> publisher) {
        Graph sGraph = ReactiveStreamsGraphBuilder.rsBuilderToGraph(Objects.requireNonNull(subscriber, "Subscriber must not be null"));
        Graph pGraph = ReactiveStreamsGraphBuilder.rsBuilderToGraph(Objects.requireNonNull(publisher, "Publisher must not be null"));
        return new ProcessorBuilderImpl(new Stages.Coupled(sGraph, pGraph), null);
    }

    @Override
    public <T, R> ProcessorBuilder<T, R> coupled(Subscriber<? super T> subscriber, Publisher<? extends R> publisher) {
        return this.coupled(this.fromSubscriber(subscriber), this.fromPublisher(publisher));
    }
}

