/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.iteration;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.stream.IntStream;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.impl.consistenthash.SegmentConsistentHash;
import org.infinispan.client.hotrod.impl.iteration.KeyTracker;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.configuration.ClassAllowList;
import org.infinispan.commons.marshall.WrappedByteArray;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.Util;

class SegmentKeyTracker
implements KeyTracker {
    private static final Log log = LogFactory.getLog(SegmentKeyTracker.class);
    private final AtomicReferenceArray<Set<WrappedByteArray>> keysPerSegment;
    private final SegmentConsistentHash segmentConsistentHash;
    private final DataFormat dataFormat;
    private volatile boolean trackSegments = true;
    private Set<WrappedByteArray> keyOnlyTracker = new HashSet<WrappedByteArray>();

    public SegmentKeyTracker(DataFormat dataFormat, SegmentConsistentHash segmentConsistentHash, Set<Integer> segments) {
        this.dataFormat = dataFormat;
        int numSegments = segmentConsistentHash.getNumSegments();
        this.keysPerSegment = new AtomicReferenceArray(numSegments);
        if (log.isTraceEnabled()) {
            log.tracef("Created SegmentKeyTracker with %d segments, filter %s", numSegments, (Object)segments);
        }
        this.segmentConsistentHash = segmentConsistentHash;
        IntStream segmentStream = segments == null ? IntStream.range(0, segmentConsistentHash.getNumSegments()) : segments.stream().mapToInt(i -> i);
        segmentStream.forEach(i -> this.keysPerSegment.set(i, new HashSet()));
    }

    private void drainKeys() {
        for (int i = 0; i < this.keysPerSegment.length(); ++i) {
            Set<WrappedByteArray> keys = this.keysPerSegment.get(i);
            if (keys != null) {
                this.keyOnlyTracker.addAll(keys);
            }
            this.keysPerSegment.set(i, null);
        }
    }

    @Override
    public boolean track(byte[] key, short status, ClassAllowList allowList) {
        if (!this.trackSegments) {
            return this.keyOnlyTracker.add(new WrappedByteArray(key));
        }
        int segment = HotRodConstants.isObjectStorage(status) ? this.segmentConsistentHash.getSegment(this.dataFormat.keyToObj(key, allowList)) : this.segmentConsistentHash.getSegment(key);
        Set<WrappedByteArray> keys = this.keysPerSegment.get(segment);
        if (keys == null) {
            this.trackSegments = false;
            this.drainKeys();
            return this.keyOnlyTracker.add(new WrappedByteArray(key));
        }
        boolean result = keys.add(new WrappedByteArray(key));
        if (log.isTraceEnabled()) {
            log.trackingSegmentKey(Util.printArray(key), segment, !result);
        }
        return result;
    }

    @Override
    public Set<Integer> missedSegments() {
        if (!this.trackSegments) {
            return null;
        }
        int length = this.keysPerSegment.length();
        if (length == 0) {
            return null;
        }
        HashSet<Integer> missed = new HashSet<Integer>(length);
        for (int i = 0; i < this.keysPerSegment.length(); ++i) {
            if (this.keysPerSegment.get(i) == null) continue;
            missed.add(i);
        }
        return missed;
    }

    @Override
    public void segmentsFinished(IntSet finishedSegments) {
        if (this.trackSegments && finishedSegments != null) {
            if (log.isTraceEnabled()) {
                log.tracef("Removing completed segments %s", (Object)finishedSegments);
            }
            finishedSegments.forEach(seg -> this.keysPerSegment.set(seg, null));
        }
    }
}

