/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.tracing.typedvalue;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, defaultImpl=Kind.class, property="kind", visible=true)
public abstract class BaseTypedValue<C extends BaseTypedValue<C, S, U>, S extends BaseTypedValue<C, S, U>, U extends BaseTypedValue<C, S, U>> {
    @JsonProperty(value="kind")
    protected Kind kind;
    @JsonProperty(value="type")
    protected String type;

    protected BaseTypedValue() {
    }

    protected BaseTypedValue(Kind kind, String type) {
        this.kind = kind;
        this.type = type;
    }

    public Kind getKind() {
        return this.kind;
    }

    public String getType() {
        return this.type;
    }

    @JsonIgnore
    public boolean isCollection() {
        return this.kind == Kind.COLLECTION;
    }

    public C toCollection() {
        if (!this.isCollection()) {
            throw new IllegalStateException(String.format("Can't convert TypedValue of kind %s to COLLECTION", new Object[]{this.getKind()}));
        }
        return (C)this;
    }

    @JsonIgnore
    public boolean isStructure() {
        return this.kind == Kind.STRUCTURE;
    }

    public S toStructure() {
        if (!this.isStructure()) {
            throw new IllegalStateException(String.format("Can't convert TypedValue of kind %s to STRUCTURE", new Object[]{this.getKind()}));
        }
        return (S)this;
    }

    @JsonIgnore
    public boolean isUnit() {
        return this.kind == Kind.UNIT;
    }

    public U toUnit() {
        if (!this.isUnit()) {
            throw new IllegalStateException(String.format("Can't convert TypedValue of kind %s to UNIT", new Object[]{this.getKind()}));
        }
        return (U)this;
    }

    public static enum Kind {
        UNIT,
        COLLECTION,
        STRUCTURE;

    }
}

