/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.service.common.handlers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.kogito.explainability.api.CounterfactualExplainabilityResult;
import org.kie.kogito.persistence.api.Storage;
import org.kie.kogito.persistence.api.query.QueryFilterFactory;
import org.kie.kogito.persistence.api.query.SortDirection;
import org.kie.kogito.trusty.service.common.handlers.ExplainabilityResultsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class CounterfactualExplainabilityResultsManagerDuplicates
implements ExplainabilityResultsManager<CounterfactualExplainabilityResult> {
    private static final Logger LOG = LoggerFactory.getLogger(CounterfactualExplainabilityResultsManagerDuplicates.class);
    private ObjectMapper mapper;

    CounterfactualExplainabilityResultsManagerDuplicates() {
    }

    @Inject
    public CounterfactualExplainabilityResultsManagerDuplicates(ObjectMapper mapper) {
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public void purge(String counterfactualId, Storage<String, CounterfactualExplainabilityResult> storage) {
        ArrayList<CounterfactualExplainabilityResult> results = new ArrayList<CounterfactualExplainabilityResult>(storage.query().sort(List.of(QueryFilterFactory.orderBy("sequenceId", SortDirection.ASC))).filter(List.of(QueryFilterFactory.equalTo("counterfactualId", counterfactualId))).execute());
        if (results.size() < 2) {
            return;
        }
        CounterfactualExplainabilityResult latestResult = (CounterfactualExplainabilityResult)results.get(results.size() - 1);
        CounterfactualExplainabilityResult penultimateResult = (CounterfactualExplainabilityResult)results.get(results.size() - 2);
        boolean inputsEqual = this.equals(latestResult.getInputs(), penultimateResult.getInputs());
        boolean outputsEqual = this.equals(latestResult.getOutputs(), penultimateResult.getOutputs());
        if (inputsEqual && outputsEqual) {
            LOG.info("The latest two Counterfactual results are equal. Removing duplicate.");
            if (latestResult.getStage().equals((Object)CounterfactualExplainabilityResult.Stage.FINAL)) {
                this.removeSolution(storage, penultimateResult);
            } else {
                this.removeSolution(storage, latestResult);
            }
        }
    }

    private boolean equals(Object o1, Object o2) {
        Object node1 = this.mapper.valueToTree(o1);
        Object node2 = this.mapper.valueToTree(o2);
        return ((JsonNode)node1).equals(node2);
    }

    private void removeSolution(Storage<String, CounterfactualExplainabilityResult> storage, CounterfactualExplainabilityResult result) {
        LOG.info(String.format("Removing duplicate solution %s, sequence %d", result.getSolutionId(), result.getSequenceId()));
        storage.remove(result.getSolutionId());
    }
}

