/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.api.enums.builtinfunctions;

import java.util.Arrays;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.special.Erf;
import org.kie.pmml.api.enums.BUILTIN_FUNCTIONS;
import org.kie.pmml.api.exceptions.KieEnumException;
import org.kie.pmml.api.exceptions.KiePMMLException;

public enum DistributionFunctions {
    NORMAL_CDF("normalCDF"),
    NORMAL_PDF("normalPDF"),
    STD_NORMAL_CDF("stdNormalCDF"),
    STD_NORMAL_PDF("stdNormalPDF"),
    ERF("erf"),
    NORMAL_IDF("normalIDF"),
    STD_NORMAL_IDF("stdNormalIDF");

    private final String name;

    private DistributionFunctions(String name) {
        this.name = name;
    }

    public static boolean isDistributionFunctions(String name) {
        return Arrays.stream(DistributionFunctions.values()).anyMatch(value -> name.equals(value.name));
    }

    public static DistributionFunctions byName(String name) {
        return Arrays.stream(DistributionFunctions.values()).filter(value -> name.equals(value.name)).findFirst().orElseThrow(() -> new KieEnumException("Failed to find DistributionFunctions with name: " + name));
    }

    public String getName() {
        return this.name;
    }

    public Object getValue(Object[] inputData) {
        switch (this) {
            case NORMAL_CDF: {
                return this.normalCDF(inputData);
            }
            case NORMAL_PDF: {
                return this.normalPDF(inputData);
            }
            case STD_NORMAL_CDF: {
                return this.stdNormalCDF(inputData);
            }
            case STD_NORMAL_PDF: {
                return this.stdNormalPDF(inputData);
            }
            case ERF: {
                return this.erf(inputData);
            }
            case NORMAL_IDF: {
                return this.normalIDF(inputData);
            }
            case STD_NORMAL_IDF: {
                return this.stdNormalIDF(inputData);
            }
        }
        throw new KiePMMLException("Unmanaged DistributionFunctions " + (Object)((Object)this));
    }

    private double normalCDF(Object[] inputData) {
        BUILTIN_FUNCTIONS.checkNumbers(inputData, 3);
        double x = ((Number)inputData[0]).doubleValue();
        double mu = ((Number)inputData[1]).doubleValue();
        double sigma = ((Number)inputData[2]).doubleValue();
        NormalDistribution normalDistribution = new NormalDistribution(mu, sigma);
        return normalDistribution.cumulativeProbability(x);
    }

    private double normalPDF(Object[] inputData) {
        BUILTIN_FUNCTIONS.checkNumbers(inputData, 3);
        double x = ((Number)inputData[0]).doubleValue();
        double mu = ((Number)inputData[1]).doubleValue();
        double sigma = ((Number)inputData[2]).doubleValue();
        NormalDistribution normalDistribution = new NormalDistribution(mu, sigma);
        return normalDistribution.density(x);
    }

    private double stdNormalCDF(Object[] inputData) {
        BUILTIN_FUNCTIONS.checkNumbers(inputData, 1);
        double x = ((Number)inputData[0]).doubleValue();
        NormalDistribution normalDistribution = new NormalDistribution();
        return normalDistribution.cumulativeProbability(x);
    }

    private double stdNormalPDF(Object[] inputData) {
        BUILTIN_FUNCTIONS.checkNumbers(inputData, 1);
        double x = ((Number)inputData[0]).doubleValue();
        NormalDistribution normalDistribution = new NormalDistribution();
        return normalDistribution.density(x);
    }

    private double erf(Object[] inputData) {
        BUILTIN_FUNCTIONS.checkNumbers(inputData, 1);
        double x = ((Number)inputData[0]).doubleValue();
        return Erf.erf(x);
    }

    private double normalIDF(Object[] inputData) {
        BUILTIN_FUNCTIONS.checkNumbers(inputData, 3);
        double p = ((Number)inputData[0]).doubleValue();
        double mu = ((Number)inputData[1]).doubleValue();
        double sigma = ((Number)inputData[2]).doubleValue();
        NormalDistribution normalDistribution = new NormalDistribution(mu, sigma);
        return normalDistribution.inverseCumulativeProbability(p);
    }

    private double stdNormalIDF(Object[] inputData) {
        BUILTIN_FUNCTIONS.checkNumbers(inputData, 1);
        double x = ((Number)inputData[0]).doubleValue();
        NormalDistribution normalDistribution = new NormalDistribution();
        return normalDistribution.inverseCumulativeProbability(x);
    }
}

