/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.plain;

import java.io.IOException;
import java.util.NoSuchElementException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.wildfly.common.iteration.CodePointIterator;
import org.wildfly.security.auth.callback.EvidenceVerifyCallback;
import org.wildfly.security.auth.callback.IdentityCredentialCallback;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.evidence.PasswordGuessEvidence;
import org.wildfly.security.mechanism._private.ElytronMessages;
import org.wildfly.security.password.interfaces.ClearPassword;
import org.wildfly.security.sasl.util.SaslWrapper;

final class PlainSaslServer
implements SaslServer,
SaslWrapper {
    private final CallbackHandler callbackHandler;
    private boolean complete;
    private String authorizedId;

    public PlainSaslServer(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    @Override
    public String getAuthorizationID() {
        if (!this.isComplete()) {
            throw ElytronMessages.saslPlain.mechAuthenticationNotComplete();
        }
        return this.authorizedId;
    }

    @Override
    public String getMechanismName() {
        return "PLAIN";
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public byte[] evaluateResponse(byte[] response) throws SaslException {
        String password;
        String loginName;
        String authorizationId;
        if (this.complete) {
            throw ElytronMessages.saslPlain.mechMessageAfterComplete().toSaslException();
        }
        this.complete = true;
        if (response.length >= 65536) {
            throw ElytronMessages.saslPlain.mechMessageTooLong().toSaslException();
        }
        CodePointIterator i = CodePointIterator.ofUtf8Bytes(response);
        try {
            CodePointIterator delimIter = i.delimitedBy(0);
            authorizationId = delimIter.hasNext() ? delimIter.drainToString() : null;
            i.next();
            loginName = delimIter.drainToString();
            i.next();
            password = delimIter.drainToString();
            if (authorizationId == null || authorizationId.isEmpty()) {
                authorizationId = loginName;
            }
        }
        catch (NoSuchElementException ignored) {
            throw ElytronMessages.saslPlain.mechInvalidMessageReceived().toSaslException();
        }
        NameCallback ncb = new NameCallback("PLAIN authentication identity", loginName);
        PasswordGuessEvidence evidence = new PasswordGuessEvidence(password.toCharArray());
        EvidenceVerifyCallback evc = new EvidenceVerifyCallback(evidence);
        try {
            this.callbackHandler.handle(new Callback[]{ncb, evc});
        }
        catch (SaslException e) {
            throw e;
        }
        catch (IOException | UnsupportedCallbackException e) {
            throw ElytronMessages.saslPlain.mechServerSideAuthenticationFailed(e).toSaslException();
        }
        finally {
            evidence.destroy();
        }
        if (!evc.isVerified()) {
            throw ElytronMessages.saslPlain.mechPasswordNotVerified().toSaslException();
        }
        try {
            this.callbackHandler.handle(new Callback[]{new IdentityCredentialCallback(new PasswordCredential(ClearPassword.createRaw("clear", password.toCharArray())), true)});
        }
        catch (UnsupportedCallbackException e) {
        }
        catch (SaslException e) {
            throw e;
        }
        catch (IOException e) {
            throw ElytronMessages.saslPlain.mechServerSideAuthenticationFailed(e).toSaslException();
        }
        AuthorizeCallback acb = new AuthorizeCallback(loginName, authorizationId);
        try {
            this.callbackHandler.handle(new Callback[]{acb});
        }
        catch (SaslException e) {
            throw e;
        }
        catch (IOException | UnsupportedCallbackException e) {
            throw ElytronMessages.saslPlain.mechServerSideAuthenticationFailed(e).toSaslException();
        }
        if (!acb.isAuthorized()) {
            throw ElytronMessages.saslPlain.mechAuthorizationFailed(loginName, authorizationId).toSaslException();
        }
        this.authorizedId = acb.getAuthorizedID();
        return null;
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        if (this.complete) {
            throw ElytronMessages.saslPlain.mechNoSecurityLayer();
        }
        throw ElytronMessages.saslPlain.mechAuthenticationNotComplete();
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        if (this.complete) {
            throw ElytronMessages.saslPlain.mechNoSecurityLayer();
        }
        throw ElytronMessages.saslPlain.mechAuthenticationNotComplete();
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        if (!this.complete) {
            throw ElytronMessages.saslPlain.mechAuthenticationNotComplete();
        }
        return null;
    }

    @Override
    public void dispose() throws SaslException {
    }
}

