/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner.processor;

import io.smallrye.openapi.api.constants.SecurityConstants;
import io.smallrye.openapi.api.models.security.ScopesImpl;
import io.smallrye.openapi.api.models.security.SecurityRequirementImpl;
import io.smallrye.openapi.runtime.util.TypeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.security.OAuthFlow;
import org.eclipse.microprofile.openapi.models.security.OAuthFlows;
import org.eclipse.microprofile.openapi.models.security.SecurityRequirement;
import org.eclipse.microprofile.openapi.models.security.SecurityScheme;
import org.jboss.jandex.MethodInfo;

public class JavaSecurityProcessor {
    private static final ThreadLocal<JavaSecurityProcessor> current = new ThreadLocal();
    private String currentSecurityScheme;
    private List<OAuthFlow> currentFlows;
    private String[] resourceRolesAllowed;

    public static void register(OpenAPI openApi) {
        JavaSecurityProcessor registry = new JavaSecurityProcessor(openApi);
        current.set(registry);
    }

    public static void addRolesAllowedToScopes(String[] roles) {
        JavaSecurityProcessor.current.get().resourceRolesAllowed = roles;
        current.get().addScopes(roles);
    }

    public static void addDeclaredRolesToScopes(String[] roles) {
        current.get().addScopes(roles);
    }

    public static void processSecurityRoles(MethodInfo method, Operation operation) {
        current.get().processSecurityRolesForMethodOperation(method, operation);
    }

    public static void remove() {
        current.remove();
    }

    private JavaSecurityProcessor(OpenAPI openApi) {
        this.checkSecurityScheme(openApi);
    }

    private void addScopes(String[] roles) {
        if (roles == null || this.currentFlows == null) {
            return;
        }
        this.currentFlows.forEach(flow -> {
            if (flow.getScopes() == null) {
                flow.setScopes(new ScopesImpl());
            }
            Arrays.stream(roles).forEach(role -> flow.getScopes().addScope((String)role, role + " role"));
        });
    }

    private void processSecurityRolesForMethodOperation(MethodInfo method, Operation operation) {
        if (this.currentSecurityScheme != null) {
            String[] rolesAllowed = (String[])TypeUtil.getAnnotationValue(method, SecurityConstants.ROLES_ALLOWED);
            if (rolesAllowed != null) {
                this.addScopes(rolesAllowed);
                this.addRolesAllowed(operation, rolesAllowed);
            } else if (this.resourceRolesAllowed != null) {
                boolean permitAll;
                boolean denyAll = TypeUtil.getAnnotation(method, SecurityConstants.DENY_ALL) != null;
                boolean bl = permitAll = TypeUtil.getAnnotation(method, SecurityConstants.PERMIT_ALL) != null;
                if (denyAll) {
                    this.addRolesAllowed(operation, new String[0]);
                } else if (!permitAll) {
                    this.addRolesAllowed(operation, this.resourceRolesAllowed);
                }
            }
        }
    }

    private void addRolesAllowed(Operation operation, String[] roles) {
        SecurityRequirement requirement;
        List<SecurityRequirement> requirements = operation.getSecurity();
        if (requirements == null) {
            SecurityRequirementImpl requirement2 = new SecurityRequirementImpl();
            requirement2.addScheme(this.currentSecurityScheme, new ArrayList<String>(Arrays.asList(roles)));
            operation.setSecurity(new ArrayList<SecurityRequirement>(Arrays.asList(requirement2)));
        } else if (requirements.size() == 1 && (requirement = requirements.get(0)).hasScheme(this.currentSecurityScheme)) {
            List<String> scopes = requirement.getScheme(this.currentSecurityScheme);
            for (String role : roles) {
                if (scopes.contains(role)) continue;
                scopes.add(role);
            }
        }
    }

    private void checkSecurityScheme(OpenAPI openApi) {
        Map.Entry<String, SecurityScheme> scheme;
        SecurityScheme.Type schemeType;
        if (openApi.getComponents() == null) {
            return;
        }
        Map<String, SecurityScheme> schemes = openApi.getComponents().getSecuritySchemes();
        if (schemes != null && schemes.size() == 1 && (schemeType = (scheme = schemes.entrySet().iterator().next()).getValue().getType()) != null) {
            switch (schemeType) {
                case OAUTH2: 
                case OPENIDCONNECT: {
                    this.saveSecurityScheme(scheme.getKey(), scheme.getValue());
                    break;
                }
            }
        }
    }

    private void saveSecurityScheme(String schemeName, SecurityScheme scheme) {
        this.currentSecurityScheme = schemeName;
        this.currentFlows = new ArrayList<OAuthFlow>();
        OAuthFlows flows = scheme.getFlows();
        if (flows != null) {
            this.saveFlow(flows.getAuthorizationCode());
            this.saveFlow(flows.getClientCredentials());
            this.saveFlow(flows.getImplicit());
            this.saveFlow(flows.getPassword());
        }
    }

    private void saveFlow(OAuthFlow flow) {
        if (flow != null && flow.getScopes() == null) {
            this.currentFlows.add(flow);
        }
    }
}

