/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.util;

import io.smallrye.openapi.api.constants.OpenApiConstants;
import io.smallrye.openapi.api.models.ComponentsImpl;
import io.smallrye.openapi.api.models.PathsImpl;
import io.smallrye.openapi.api.models.media.ContentImpl;
import io.smallrye.openapi.api.models.media.MediaTypeImpl;
import io.smallrye.openapi.api.models.responses.APIResponsesImpl;
import io.smallrye.openapi.api.util.MergeUtil;
import io.smallrye.openapi.runtime.util.JandexUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.eclipse.microprofile.openapi.models.Components;
import org.eclipse.microprofile.openapi.models.Constructible;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.Paths;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.MediaType;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.eclipse.microprofile.openapi.models.responses.APIResponses;
import org.eclipse.microprofile.openapi.models.tags.Tag;

public class ModelUtil {
    private ModelUtil() {
    }

    public static void addTag(OpenAPI openApi, Tag tag) {
        List<Tag> tags = openApi.getTags();
        if (tags == null || tags.isEmpty()) {
            openApi.addTag(tag);
            return;
        }
        Tag current = tags.stream().filter(t -> t.getName().equals(tag.getName())).findFirst().orElse(null);
        int currentIndex = tags.indexOf(current);
        if (current != null) {
            Tag replacement = MergeUtil.mergeObjects(current, tag);
            tags = new ArrayList<Tag>(tags);
            tags.set(currentIndex, replacement);
            openApi.setTags(tags);
        } else {
            openApi.addTag(tag);
        }
    }

    public static Components components(OpenAPI openApi) {
        if (openApi.getComponents() == null) {
            openApi.setComponents(new ComponentsImpl());
        }
        return openApi.getComponents();
    }

    public static <T> T getComponent(OpenAPI openApi, String ref) {
        String[] split;
        Components components = openApi.getComponents();
        Map<String, Constructible> types = null;
        Object value = null;
        if (components != null && ref.startsWith("#") && (split = ref.split("/")).length > 1) {
            String name = split[split.length - 1];
            JandexUtil.RefType type = JandexUtil.RefType.fromComponentPath(split[split.length - 2]);
            if (type != null) {
                switch (type) {
                    case CALLBACK: {
                        types = components.getCallbacks();
                        break;
                    }
                    case EXAMPLE: {
                        types = components.getExamples();
                        break;
                    }
                    case HEADER: {
                        types = components.getHeaders();
                        break;
                    }
                    case LINK: {
                        types = components.getLinks();
                        break;
                    }
                    case PARAMETER: {
                        types = components.getParameters();
                        break;
                    }
                    case REQUEST_BODY: {
                        types = components.getRequestBodies();
                        break;
                    }
                    case RESPONSE: {
                        types = components.getResponses();
                        break;
                    }
                    case SCHEMA: {
                        types = components.getSchemas();
                        break;
                    }
                    case SECURITY_SCHEME: {
                        types = components.getSecuritySchemes();
                        break;
                    }
                }
            }
            value = types != null ? types.get(name) : null;
        }
        return value;
    }

    public static Paths paths(OpenAPI openApi) {
        if (openApi.getPaths() == null) {
            openApi.setPaths(new PathsImpl());
        }
        return openApi.getPaths();
    }

    public static APIResponses responses(Operation operation) {
        if (operation.getResponses() == null) {
            operation.setResponses(new APIResponsesImpl());
        }
        return operation.getResponses();
    }

    public static boolean parameterHasSchema(Parameter parameter) {
        if (parameter.getSchema() != null) {
            return true;
        }
        Map<String, MediaType> mediaTypes = ModelUtil.getMediaTypesOrEmpty(parameter.getContent());
        if (!mediaTypes.isEmpty()) {
            for (MediaType mediaType : mediaTypes.values()) {
                if (mediaType.getSchema() == null) continue;
                return true;
            }
        }
        return false;
    }

    public static List<Schema> getParameterSchemas(Parameter parameter) {
        if (parameter.getSchema() != null) {
            return Arrays.asList(parameter.getSchema());
        }
        Map<String, MediaType> mediaTypes = ModelUtil.getMediaTypesOrEmpty(parameter.getContent());
        if (!mediaTypes.isEmpty()) {
            ArrayList<Schema> schemas = new ArrayList<Schema>(mediaTypes.size());
            for (MediaType mediaType : mediaTypes.values()) {
                if (mediaType.getSchema() == null) continue;
                schemas.add(mediaType.getSchema());
            }
        }
        return Collections.emptyList();
    }

    public static void setParameterSchema(Parameter parameter, Schema schema) {
        if (schema == null) {
            return;
        }
        if (parameter.getContent() == null) {
            parameter.schema(schema);
            return;
        }
        Content content = parameter.getContent();
        Map<String, MediaType> mediaTypes = ModelUtil.getMediaTypesOrEmpty(content);
        if (mediaTypes.isEmpty()) {
            String[] defMediaTypes;
            for (String mediaTypeName : defMediaTypes = OpenApiConstants.DEFAULT_MEDIA_TYPES.get()) {
                MediaTypeImpl mediaType = new MediaTypeImpl();
                mediaType.setSchema(schema);
                content.addMediaType(mediaTypeName, mediaType);
            }
            return;
        }
        for (String mediaTypeName : mediaTypes.keySet()) {
            MediaType mediaType = content.getMediaType(mediaTypeName);
            mediaType.setSchema(schema);
        }
    }

    public static boolean requestBodyHasSchema(RequestBody requestBody) {
        Map<String, MediaType> mediaTypes = ModelUtil.getMediaTypesOrEmpty(requestBody.getContent());
        if (!mediaTypes.isEmpty()) {
            for (MediaType mediaType : mediaTypes.values()) {
                if (mediaType.getSchema() == null) continue;
                return true;
            }
        }
        return false;
    }

    public static void setRequestBodySchema(RequestBody requestBody, Schema schema, String[] mediaTypes) {
        Map<String, MediaType> contentMediaTypes;
        Content content = requestBody.getContent();
        if (content == null) {
            content = new ContentImpl();
            requestBody.setContent(content);
        }
        if ((contentMediaTypes = ModelUtil.getMediaTypesOrEmpty(content)).isEmpty()) {
            String[] requestBodyTypes = mediaTypes != null && mediaTypes.length > 0 ? mediaTypes : OpenApiConstants.DEFAULT_MEDIA_TYPES.get();
            for (String mediaTypeName : requestBodyTypes) {
                MediaTypeImpl mediaType = new MediaTypeImpl();
                mediaType.setSchema(schema);
                content.addMediaType(mediaTypeName, mediaType);
            }
            return;
        }
        for (String mediaTypeName : contentMediaTypes.keySet()) {
            MediaType mediaType = content.getMediaType(mediaTypeName);
            mediaType.setSchema(schema);
        }
    }

    static Map<String, MediaType> getMediaTypesOrEmpty(Content content) {
        if (content != null && content.getMediaTypes() != null) {
            return content.getMediaTypes();
        }
        return Collections.emptyMap();
    }

    public static String nameFromRef(String ref) {
        String[] split = ref.split("/");
        return split[split.length - 1];
    }

    public static <V> Map<String, V> unmodifiableMap(Map<String, V> map) {
        return map != null ? Collections.unmodifiableMap(map) : null;
    }

    public static <V> Map<String, V> replace(Map<String, V> modified, UnaryOperator<Map<String, V>> factory) {
        Map replacement = modified == null ? null : (Map)factory.apply(modified);
        return replacement;
    }

    public static <V> Map<String, V> add(String key, V value, Map<String, V> map, Supplier<Map<String, V>> factory) {
        if (value != null) {
            if (map == null) {
                map = factory.get();
            }
            map.put(key, value);
        }
        return map;
    }

    public static <V> void remove(Map<String, V> map, String key) {
        if (map != null) {
            map.remove(key);
        }
    }

    public static <V> List<V> unmodifiableList(List<V> list) {
        return list != null ? Collections.unmodifiableList(list) : null;
    }

    public static <V> List<V> replace(List<V> modified, UnaryOperator<List<V>> factory) {
        List replacement = modified == null ? null : (List)factory.apply(modified);
        return replacement;
    }

    public static <V> List<V> add(V value, List<V> list, Supplier<List<V>> factory) {
        if (value != null) {
            if (list == null) {
                list = factory.get();
            }
            list.add(value);
        }
        return list;
    }

    public static <V> void remove(List<V> list, V value) {
        if (list != null) {
            list.remove(value);
        }
    }
}

