/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging;

import io.smallrye.mutiny.Uni;
import io.smallrye.reactive.messaging.Invoker;
import io.smallrye.reactive.messaging.MediatorConfiguration;
import io.smallrye.reactive.messaging.MessageConverter;
import io.smallrye.reactive.messaging.PublisherDecorator;
import io.smallrye.reactive.messaging.connectors.WorkerPoolRegistry;
import io.smallrye.reactive.messaging.extension.HealthCenter;
import io.smallrye.reactive.messaging.helpers.BroadcastHelper;
import io.smallrye.reactive.messaging.helpers.TypeUtils;
import io.smallrye.reactive.messaging.i18n.ProviderExceptions;
import io.smallrye.reactive.messaging.i18n.ProviderLogging;
import io.smallrye.reactive.messaging.i18n.ProviderMessages;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.Prioritized;
import org.eclipse.microprofile.reactive.messaging.Acknowledgment;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.eclipse.microprofile.reactive.streams.operators.SubscriberBuilder;

public abstract class AbstractMediator {
    protected final MediatorConfiguration configuration;
    protected WorkerPoolRegistry workerPoolRegistry;
    private Invoker invoker;
    private Instance<PublisherDecorator> decorators;
    protected HealthCenter health;
    private Instance<MessageConverter> converters;

    public AbstractMediator(MediatorConfiguration configuration) {
        this.configuration = configuration;
    }

    public synchronized void setInvoker(Invoker invoker) {
        this.invoker = invoker;
    }

    public void setDecorators(Instance<PublisherDecorator> decorators) {
        this.decorators = decorators;
    }

    public void setConverters(Instance<MessageConverter> converters) {
        this.converters = converters;
    }

    public void setWorkerPoolRegistry(WorkerPoolRegistry workerPoolRegistry) {
        this.workerPoolRegistry = workerPoolRegistry;
    }

    public void run() {
    }

    public void connectToUpstream(PublisherBuilder<? extends Message<?>> publisher) {
    }

    public MediatorConfiguration configuration() {
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Object bean) {
        AbstractMediator abstractMediator = this;
        synchronized (abstractMediator) {
            if (this.invoker == null) {
                this.invoker = args -> {
                    try {
                        return this.configuration.getMethod().invoke(bean, args);
                    }
                    catch (Exception e) {
                        throw ProviderExceptions.ex.processingException(this.configuration.methodAsString(), e);
                    }
                };
            }
        }
        Objects.requireNonNull(this.invoker, ProviderMessages.msg.invokerNotInitialized());
        if (this.configuration.isBlocking()) {
            Objects.requireNonNull(this.workerPoolRegistry, ProviderMessages.msg.workerPoolNotInitialized());
        }
    }

    protected <T> T invoke(Object ... args) {
        try {
            return (T)this.invoker.invoke(args);
        }
        catch (RuntimeException e) {
            ProviderLogging.log.methodException(this.configuration().methodAsString(), e);
            throw e;
        }
    }

    protected <T> Uni<T> invokeBlocking(Object ... args) {
        try {
            return this.workerPoolRegistry.executeWork(future -> {
                try {
                    Object result = this.invoker.invoke(args);
                    if (result instanceof CompletionStage) {
                        ((CompletionStage)result).thenAccept(x -> future.complete(x));
                    } else {
                        future.complete(result);
                    }
                }
                catch (RuntimeException e) {
                    ProviderLogging.log.methodException(this.configuration().methodAsString(), e);
                    future.fail(e);
                }
            }, this.configuration.getWorkerPoolName(), this.configuration.isBlockingExecutionOrdered());
        }
        catch (RuntimeException e) {
            ProviderLogging.log.methodException(this.configuration().methodAsString(), e);
            throw e;
        }
    }

    protected CompletionStage<Message<?>> getAckOrCompletion(Message<?> message) {
        CompletionStage<Void> ack = message.ack();
        if (ack != null) {
            return ack.thenApply(x -> message);
        }
        return CompletableFuture.completedFuture(message);
    }

    public PublisherBuilder<? extends Message<?>> getStream() {
        return null;
    }

    public MediatorConfiguration getConfiguration() {
        return this.configuration;
    }

    public String getMethodAsString() {
        return this.configuration.methodAsString();
    }

    public SubscriberBuilder<Message<?>, Void> getComputedSubscriber() {
        return null;
    }

    public abstract boolean isConnected();

    protected Function<Message<?>, ? extends CompletionStage<? extends Message<?>>> managePreProcessingAck() {
        return this::handlePreProcessingAck;
    }

    protected CompletionStage<Message<?>> handlePreProcessingAck(Message<?> message) {
        if (this.configuration.getAcknowledgment() == Acknowledgment.Strategy.PRE_PROCESSING) {
            return this.getAckOrCompletion(message);
        }
        return CompletableFuture.completedFuture(message);
    }

    public PublisherBuilder<? extends Message<?>> decorate(PublisherBuilder<? extends Message<?>> input) {
        if (input == null) {
            return null;
        }
        for (PublisherDecorator decorator : this.decorators) {
            input = decorator.decorate(input, this.getConfiguration().getOutgoing());
        }
        if (this.configuration.getBroadcast()) {
            return BroadcastHelper.broadcastPublisher(input.buildRs(), this.configuration.getNumberOfSubscriberBeforeConnecting());
        }
        return input;
    }

    public void setHealth(HealthCenter health) {
        this.health = health;
    }

    public PublisherBuilder<? extends Message<?>> convert(PublisherBuilder<? extends Message<?>> upstream) {
        final Type injectedPayloadType = this.configuration.getIngestedPayloadType();
        if (injectedPayloadType != null) {
            return upstream.map(new Function<Message<?>, Message<?>>(){
                MessageConverter actual;

                @Override
                public Message<?> apply(Message<?> o) {
                    if (injectedPayloadType == null) {
                        return o;
                    }
                    if (o.getPayload() != null && o.getPayload().getClass().equals(injectedPayloadType)) {
                        return o;
                    }
                    if (this.actual != null) {
                        return this.actual.convert(o, injectedPayloadType);
                    }
                    if (o.getPayload() != null && TypeUtils.isAssignable(o.getPayload().getClass(), injectedPayloadType)) {
                        this.actual = MessageConverter.IdentityConverter.INSTANCE;
                        return o;
                    }
                    for (MessageConverter conv : AbstractMediator.this.getSortedConverters()) {
                        if (!conv.canConvert(o, injectedPayloadType)) continue;
                        this.actual = conv;
                        return this.actual.convert(o, injectedPayloadType);
                    }
                    return o;
                }
            });
        }
        return upstream;
    }

    private List<MessageConverter> getSortedConverters() {
        if (this.converters.isUnsatisfied()) {
            return Collections.emptyList();
        }
        return this.converters.stream().sorted(new Comparator<MessageConverter>(){

            @Override
            public int compare(MessageConverter si1, MessageConverter si2) {
                int p1 = 0;
                int p2 = 0;
                if (si1 instanceof Prioritized) {
                    p1 = si1.getPriority();
                }
                if (si2 instanceof Prioritized) {
                    p2 = si2.getPriority();
                }
                if (si1.equals(si2)) {
                    return 0;
                }
                return Integer.compare(p1, p2);
            }
        }).collect(Collectors.toList());
    }
}

