/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.service.common.messaging;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.kie.kogito.explainability.api.CounterfactualDomainCategoricalDto;
import org.kie.kogito.explainability.api.CounterfactualDomainDto;
import org.kie.kogito.explainability.api.CounterfactualDomainRangeDto;
import org.kie.kogito.explainability.api.CounterfactualSearchDomainCollectionDto;
import org.kie.kogito.explainability.api.CounterfactualSearchDomainDto;
import org.kie.kogito.explainability.api.CounterfactualSearchDomainStructureDto;
import org.kie.kogito.explainability.api.CounterfactualSearchDomainUnitDto;
import org.kie.kogito.tracing.typedvalue.CollectionValue;
import org.kie.kogito.tracing.typedvalue.StructureValue;
import org.kie.kogito.tracing.typedvalue.TypedValue;
import org.kie.kogito.tracing.typedvalue.UnitValue;
import org.kie.kogito.trusty.storage.api.model.CounterfactualDomain;
import org.kie.kogito.trusty.storage.api.model.CounterfactualDomainCategorical;
import org.kie.kogito.trusty.storage.api.model.CounterfactualDomainRange;
import org.kie.kogito.trusty.storage.api.model.CounterfactualSearchDomain;
import org.kie.kogito.trusty.storage.api.model.TypedVariableWithValue;

public class MessagingUtils {
    private MessagingUtils() {
    }

    public static TypedValue modelToTracingTypedValue(TypedVariableWithValue value) {
        if (value == null) {
            return null;
        }
        switch (value.getKind()) {
            case UNIT: {
                return new UnitValue(value.getTypeRef(), null, value.getValue());
            }
            case COLLECTION: {
                return new CollectionValue(value.getTypeRef(), MessagingUtils.modelToTracingTypedValueCollection(value.getComponents()));
            }
            case STRUCTURE: {
                return new StructureValue(value.getTypeRef(), MessagingUtils.modelToTracingTypedValueMap(value.getComponents()));
            }
        }
        throw new IllegalStateException("Can't convert org.kie.kogito.trusty.storage.api.model.TypedVariable of kind " + value.getKind() + " to TypedValue");
    }

    public static Collection<TypedValue> modelToTracingTypedValueCollection(Collection<TypedVariableWithValue> input) {
        if (input == null) {
            return null;
        }
        return input.stream().map(MessagingUtils::modelToTracingTypedValue).collect(Collectors.toList());
    }

    public static Map<String, TypedValue> modelToTracingTypedValueMap(Collection<TypedVariableWithValue> input) {
        if (input == null) {
            return null;
        }
        return input.stream().filter(m -> m.getName() != null).collect(HashMap::new, (m, v) -> m.put(v.getName(), MessagingUtils.modelToTracingTypedValue(v)), HashMap::putAll);
    }

    public static CounterfactualSearchDomainDto modelToCounterfactualSearchDomainDto(CounterfactualSearchDomain value) {
        if (value == null) {
            return null;
        }
        switch (value.getKind()) {
            case UNIT: {
                return new CounterfactualSearchDomainUnitDto(value.getTypeRef(), value.isFixed(), MessagingUtils.modelToCounterfactualDomain(value.getDomain()));
            }
            case COLLECTION: {
                return new CounterfactualSearchDomainCollectionDto(value.getTypeRef(), MessagingUtils.modelToCounterfactualSearchDomainDtoCollection(value.getComponents()));
            }
            case STRUCTURE: {
                return new CounterfactualSearchDomainStructureDto(value.getTypeRef(), MessagingUtils.modelToCounterfactualSearchDomainDtoMap(value.getComponents()));
            }
        }
        throw new IllegalStateException("Can't convert CounterfactualSearchDomain of kind " + value.getKind() + " to CounterfactualSearchDomainDto");
    }

    public static CounterfactualDomainDto modelToCounterfactualDomain(CounterfactualDomain domain) {
        if (domain == null) {
            return null;
        }
        switch (domain.getType()) {
            case CATEGORICAL: {
                CounterfactualDomainCategorical categorical = (CounterfactualDomainCategorical)domain;
                return new CounterfactualDomainCategoricalDto(categorical.getCategories());
            }
            case RANGE: {
                CounterfactualDomainRange range = (CounterfactualDomainRange)domain;
                return new CounterfactualDomainRangeDto(range.getLowerBound(), range.getUpperBound());
            }
        }
        throw new IllegalStateException("Can't convert CounterfactualDomain of type " + domain.getType() + " to org.kie.kogito.explainability.api.CounterfactualDomain");
    }

    public static Collection<CounterfactualSearchDomainDto> modelToCounterfactualSearchDomainDtoCollection(Collection<CounterfactualSearchDomain> searchDomains) {
        if (searchDomains == null) {
            return null;
        }
        return searchDomains.stream().map(MessagingUtils::modelToCounterfactualSearchDomainDto).collect(Collectors.toList());
    }

    public static Map<String, CounterfactualSearchDomainDto> modelToCounterfactualSearchDomainDtoMap(Collection<CounterfactualSearchDomain> searchDomains) {
        if (searchDomains == null) {
            return null;
        }
        return searchDomains.stream().filter(m -> m.getName() != null).collect(HashMap::new, (m, v) -> m.put(v.getName(), MessagingUtils.modelToCounterfactualSearchDomainDto(v)), HashMap::putAll);
    }
}

