/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.service.common.messaging.incoming;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.cloudevents.CloudEvent;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.reactive.messaging.Incoming;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.kie.kogito.explainability.api.BaseExplainabilityResultDto;
import org.kie.kogito.explainability.api.ExplainabilityStatus;
import org.kie.kogito.explainability.api.FeatureImportanceDto;
import org.kie.kogito.explainability.api.LIMEExplainabilityResultDto;
import org.kie.kogito.explainability.api.SaliencyDto;
import org.kie.kogito.trusty.service.common.TrustyService;
import org.kie.kogito.trusty.service.common.messaging.BaseEventConsumer;
import org.kie.kogito.trusty.storage.api.model.BaseExplainabilityResult;
import org.kie.kogito.trusty.storage.api.model.Decision;
import org.kie.kogito.trusty.storage.api.model.DecisionOutcome;
import org.kie.kogito.trusty.storage.api.model.FeatureImportanceModel;
import org.kie.kogito.trusty.storage.api.model.LIMEExplainabilityResult;
import org.kie.kogito.trusty.storage.api.model.SaliencyModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ExplainabilityResultConsumer
extends BaseEventConsumer<BaseExplainabilityResultDto> {
    private static final Logger LOG = LoggerFactory.getLogger(ExplainabilityResultConsumer.class);
    private static final TypeReference<BaseExplainabilityResultDto> CLOUD_EVENT_TYPE = new TypeReference<BaseExplainabilityResultDto>(){};

    ExplainabilityResultConsumer() {
    }

    @Inject
    public ExplainabilityResultConsumer(TrustyService service, ObjectMapper mapper) {
        super(service, mapper);
    }

    protected static BaseExplainabilityResult explainabilityResultFrom(BaseExplainabilityResultDto dto, Decision decision) {
        if (dto == null) {
            return null;
        }
        if (dto instanceof LIMEExplainabilityResultDto) {
            LIMEExplainabilityResultDto lime = (LIMEExplainabilityResultDto)dto;
            Map outcomeNameToIdMap = decision == null ? Collections.emptyMap() : decision.getOutcomes().stream().collect(Collectors.toUnmodifiableMap(DecisionOutcome::getOutcomeName, DecisionOutcome::getOutcomeId));
            List<SaliencyModel> saliencies = lime.getSaliencies() == null ? null : lime.getSaliencies().entrySet().stream().map(e -> ExplainabilityResultConsumer.saliencyFrom((String)outcomeNameToIdMap.get(e.getKey()), (String)e.getKey(), (SaliencyDto)e.getValue())).collect(Collectors.toList());
            return new LIMEExplainabilityResult(dto.getExecutionId(), ExplainabilityResultConsumer.statusFrom(dto.getStatus()), dto.getStatusDetails(), saliencies);
        }
        throw new IllegalArgumentException(String.format("Explainability result for '%s' is not supported", dto.getClass().getName()));
    }

    protected static FeatureImportanceModel featureImportanceFrom(FeatureImportanceDto dto) {
        if (dto == null) {
            return null;
        }
        return new FeatureImportanceModel(dto.getFeatureName(), dto.getScore());
    }

    protected static SaliencyModel saliencyFrom(String outcomeId, String outcomeName, SaliencyDto dto) {
        if (dto == null) {
            return null;
        }
        List<FeatureImportanceModel> featureImportanceModel = dto.getFeatureImportance() == null ? null : dto.getFeatureImportance().stream().map(ExplainabilityResultConsumer::featureImportanceFrom).collect(Collectors.toList());
        return new SaliencyModel(outcomeId, outcomeName, featureImportanceModel);
    }

    protected static org.kie.kogito.trusty.storage.api.model.ExplainabilityStatus statusFrom(ExplainabilityStatus status) {
        switch (status) {
            case SUCCEEDED: {
                return org.kie.kogito.trusty.storage.api.model.ExplainabilityStatus.SUCCEEDED;
            }
            case FAILED: {
                return org.kie.kogito.trusty.storage.api.model.ExplainabilityStatus.FAILED;
            }
        }
        return null;
    }

    @Override
    @Incoming(value="trusty-explainability-result")
    public CompletionStage<Void> handleMessage(Message<String> message) {
        return super.handleMessage(message);
    }

    @Override
    protected void internalHandleCloudEvent(CloudEvent cloudEvent, BaseExplainabilityResultDto payload) {
        String executionId = payload.getExecutionId();
        Decision decision = this.getDecisionById(executionId);
        if (decision == null) {
            LOG.warn("Can't find decision related to explainability result (executionId={})", (Object)executionId);
        }
        this.service.storeExplainabilityResult(executionId, ExplainabilityResultConsumer.explainabilityResultFrom(payload, decision));
    }

    @Override
    protected TypeReference<BaseExplainabilityResultDto> getEventType() {
        return CLOUD_EVENT_TYPE;
    }

    protected Decision getDecisionById(String executionId) {
        try {
            return this.service.getDecisionById(executionId);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

