/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.storage.infinispan;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.infinispan.protostream.MessageMarshaller;
import org.kie.kogito.trusty.storage.api.model.CounterfactualDomainCategorical;
import org.kie.kogito.trusty.storage.infinispan.AbstractModelMarshaller;

public class CounterfactualDomainCategoricalMarshaller
extends AbstractModelMarshaller<CounterfactualDomainCategorical> {
    public CounterfactualDomainCategoricalMarshaller(ObjectMapper mapper) {
        super(mapper, CounterfactualDomainCategorical.class);
    }

    @Override
    public CounterfactualDomainCategorical readFrom(MessageMarshaller.ProtoStreamReader reader) throws IOException {
        ArrayList storedCategories = reader.readCollection("categories", new ArrayList(), String.class);
        Collection domainCategories = storedCategories.stream().map(this::safeJsonFromString).collect(Collectors.toList());
        return new CounterfactualDomainCategorical(domainCategories);
    }

    @Override
    public void writeTo(MessageMarshaller.ProtoStreamWriter writer, CounterfactualDomainCategorical input) throws IOException {
        Collection categories = input.getCategories().stream().map(this::safeStringFromJson).collect(Collectors.toList());
        writer.writeCollection("categories", categories, String.class);
    }

    public JsonNode safeJsonFromString(String value) {
        try {
            return this.jsonFromString(value);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String safeStringFromJson(JsonNode value) {
        try {
            return this.stringFromJson(value);
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

