/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.storage.infinispan;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import org.infinispan.protostream.MessageMarshaller;
import org.kie.kogito.trusty.storage.api.model.Decision;
import org.kie.kogito.trusty.storage.api.model.DecisionInput;
import org.kie.kogito.trusty.storage.api.model.DecisionOutcome;
import org.kie.kogito.trusty.storage.api.model.ExecutionType;
import org.kie.kogito.trusty.storage.infinispan.AbstractModelMarshaller;

public class DecisionMarshaller
extends AbstractModelMarshaller<Decision> {
    public DecisionMarshaller(ObjectMapper mapper) {
        super(mapper, Decision.class);
    }

    @Override
    public Decision readFrom(MessageMarshaller.ProtoStreamReader reader) throws IOException {
        ExecutionType executionType = DecisionMarshaller.enumFromString(reader.readString("executionType"), ExecutionType.class);
        if (executionType != ExecutionType.DECISION) {
            throw new IllegalStateException("Unsupported execution type: " + executionType);
        }
        return new Decision(reader.readString("executionId"), reader.readString("sourceUrl"), reader.readString("serviceUrl"), reader.readLong("executionTimestamp"), reader.readBoolean("hasSucceeded"), reader.readString("executorName"), reader.readString("executedModelName"), reader.readString("executedModelNamespace"), reader.readCollection("inputs", new ArrayList(), DecisionInput.class), reader.readCollection("outcomes", new ArrayList(), DecisionOutcome.class));
    }

    @Override
    public void writeTo(MessageMarshaller.ProtoStreamWriter writer, Decision input) throws IOException {
        writer.writeString("executionType", DecisionMarshaller.stringFromEnum(input.getExecutionType()));
        writer.writeString("executionId", input.getExecutionId());
        writer.writeString("sourceUrl", input.getSourceUrl());
        writer.writeString("serviceUrl", input.getServiceUrl());
        writer.writeLong("executionTimestamp", input.getExecutionTimestamp());
        writer.writeBoolean("hasSucceeded", input.hasSucceeded());
        writer.writeString("executorName", input.getExecutorName());
        writer.writeString("executedModelName", input.getExecutedModelName());
        writer.writeString("executedModelNamespace", input.getExecutedModelNamespace());
        writer.writeCollection("inputs", input.getInputs(), DecisionInput.class);
        writer.writeCollection("outcomes", input.getOutcomes(), DecisionOutcome.class);
    }
}

