/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.storage.infinispan;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.infinispan.protostream.FileDescriptorSource;
import org.kie.kogito.trusty.storage.infinispan.CounterfactualDomainCategoricalMarshaller;
import org.kie.kogito.trusty.storage.infinispan.CounterfactualDomainMarshaller;
import org.kie.kogito.trusty.storage.infinispan.CounterfactualDomainRangeMarshaller;
import org.kie.kogito.trusty.storage.infinispan.CounterfactualMarshaller;
import org.kie.kogito.trusty.storage.infinispan.CounterfactualResultMarshaller;
import org.kie.kogito.trusty.storage.infinispan.CounterfactualSearchDomainMarshaller;
import org.kie.kogito.trusty.storage.infinispan.DMNModelWithMetadataMarshaller;
import org.kie.kogito.trusty.storage.infinispan.DecisionInputMarshaller;
import org.kie.kogito.trusty.storage.infinispan.DecisionMarshaller;
import org.kie.kogito.trusty.storage.infinispan.DecisionOutcomeMarshaller;
import org.kie.kogito.trusty.storage.infinispan.FeatureImportanceModelMarshaller;
import org.kie.kogito.trusty.storage.infinispan.LIMEExplainabilityResultMarshaller;
import org.kie.kogito.trusty.storage.infinispan.MessageExceptionFieldMarshaller;
import org.kie.kogito.trusty.storage.infinispan.MessageMarshaller;
import org.kie.kogito.trusty.storage.infinispan.SaliencyModelMarshaller;
import org.kie.kogito.trusty.storage.infinispan.TypedVariableWithValueMarshaller;

@ApplicationScoped
public class ProtostreamProducer {
    @Inject
    ObjectMapper mapper;

    @Produces
    FileDescriptorSource kogitoTypesDescriptor() throws IOException {
        FileDescriptorSource source = new FileDescriptorSource();
        source.addProtoFile("decision.proto", Thread.currentThread().getContextClassLoader().getResourceAsStream("META-INF/decision.proto"));
        return source;
    }

    @Produces
    org.infinispan.protostream.MessageMarshaller decisionMarshaller() {
        return new DecisionMarshaller(this.mapper);
    }

    @Produces
    org.infinispan.protostream.MessageMarshaller decisionInputMarshaller() {
        return new DecisionInputMarshaller(this.mapper);
    }

    @Produces
    org.infinispan.protostream.MessageMarshaller decisionOutcomeMarshaller() {
        return new DecisionOutcomeMarshaller(this.mapper);
    }

    @Produces
    org.infinispan.protostream.MessageMarshaller explainabilityResultMarshaller() {
        return new LIMEExplainabilityResultMarshaller(this.mapper);
    }

    @Produces
    org.infinispan.protostream.MessageMarshaller featureImportanceMarshaller() {
        return new FeatureImportanceModelMarshaller(this.mapper);
    }

    @Produces
    org.infinispan.protostream.MessageMarshaller messageExceptionFieldMarshaller() {
        return new MessageExceptionFieldMarshaller(this.mapper);
    }

    @Produces
    org.infinispan.protostream.MessageMarshaller messageMarshaller() {
        return new MessageMarshaller(this.mapper);
    }

    @Produces
    org.infinispan.protostream.MessageMarshaller saliencyMarshaller() {
        return new SaliencyModelMarshaller(this.mapper);
    }

    @Produces
    org.infinispan.protostream.MessageMarshaller typedValueMarshaller() {
        return new TypedVariableWithValueMarshaller(this.mapper);
    }

    @Produces
    org.infinispan.protostream.MessageMarshaller dmnModelMarshaller() {
        return new DMNModelWithMetadataMarshaller(this.mapper);
    }

    @Produces
    org.infinispan.protostream.MessageMarshaller counterfactualMarshaller() {
        return new CounterfactualMarshaller(this.mapper);
    }

    @Produces
    org.infinispan.protostream.MessageMarshaller counterfactualDomainMarshaller() {
        return new CounterfactualDomainMarshaller(this.mapper);
    }

    @Produces
    org.infinispan.protostream.MessageMarshaller counterfactualDomainCategoricalMarshaller() {
        return new CounterfactualDomainCategoricalMarshaller(this.mapper);
    }

    @Produces
    org.infinispan.protostream.MessageMarshaller counterfactualDomainRangeMarshaller() {
        return new CounterfactualDomainRangeMarshaller(this.mapper);
    }

    @Produces
    org.infinispan.protostream.MessageMarshaller counterfactualSearchDomainMarshaller() {
        return new CounterfactualSearchDomainMarshaller(this.mapper);
    }

    @Produces
    org.infinispan.protostream.MessageMarshaller counterfactualResultMarshaller() {
        return new CounterfactualResultMarshaller(this.mapper);
    }
}

