/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devconsole.runtime.spi;

import io.vertx.core.http.Cookie;
import io.vertx.ext.web.RoutingContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;

public class FlashScopeUtil {
    private static final String FLASH_COOKIE_NAME = "_flash";
    private static final String FLASH_CONTEXT_DATA_NAME = "flash";

    public static void setFlash(RoutingContext event, Map<String, Object> data) {
        event.response().addCookie(Cookie.cookie(FLASH_COOKIE_NAME, Base64.getEncoder().encodeToString(FlashScopeUtil.marshallMap(data))));
    }

    public static Object getFlash(RoutingContext event) {
        return event.data().get(FLASH_CONTEXT_DATA_NAME);
    }

    public static void handleFlashCookie(RoutingContext event) {
        byte[] decoded;
        byte[] bytes;
        Cookie cookie = event.request().getCookie(FLASH_COOKIE_NAME);
        if (cookie != null && (bytes = cookie.getValue().getBytes()) != null && bytes.length != 0 && (decoded = Base64.getDecoder().decode(bytes)).length > 0) {
            Map<String, Object> data = FlashScopeUtil.unmarshallMap(decoded);
            event.data().put(FLASH_CONTEXT_DATA_NAME, data);
        }
        event.response().removeCookie(FLASH_COOKIE_NAME);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static byte[] marshallMap(Map<String, Object> data) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
                oos.writeObject(data);
                byArray = baos.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static Map<String, Object> unmarshallMap(byte[] data) {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(data);){
            Map map;
            try (ObjectInputStream oos = new ObjectInputStream(bais);){
                map = (Map)oos.readObject();
            }
            return map;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void setFlashMessage(RoutingContext event, String message) {
        FlashScopeUtil.setFlashMessage(event, message, FlashMessageStatus.SUCCESS, null);
    }

    public static void setFlashMessage(RoutingContext event, String message, Duration displayTime) {
        FlashScopeUtil.setFlashMessage(event, message, FlashMessageStatus.SUCCESS, displayTime);
    }

    public static void setFlashMessage(RoutingContext event, String message, FlashMessageStatus messageStatus, Duration displayTime) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        HashMap<String, String> messageData = new HashMap<String, String>();
        messageData.put("text", message);
        messageData.put("class", messageStatus.cssClass);
        data.put("message", messageData);
        data.put("displayTime", displayTime != null ? displayTime.toMillis() : 2000L);
        FlashScopeUtil.setFlash(event, data);
    }

    public static enum FlashMessageStatus {
        SUCCESS("success"),
        ERROR("danger");

        public final String cssClass;

        private FlashMessageStatus(String cssClass) {
            this.cssClass = cssClass;
        }
    }
}

