/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.context;

import io.smallrye.context.SmallRyeContextManagerProvider;
import io.smallrye.context.SmallRyeManagedExecutor;
import io.smallrye.context.SmallRyeThreadContext;
import io.smallrye.context.impl.DefaultValues;
import io.smallrye.context.impl.ThreadContextProviderPlan;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.eclipse.microprofile.context.spi.ContextManager;
import org.eclipse.microprofile.context.spi.ContextManagerExtension;
import org.eclipse.microprofile.context.spi.ThreadContextProvider;

public class SmallRyeContextManager
implements ContextManager {
    public static final String NONE = "None";
    public static final String[] NO_STRING = new String[0];
    public static final String[] ALL_REMAINING_ARRAY = new String[]{"Remaining"};
    private final List<ContextManagerExtension> extensions;
    private final Map<String, ThreadContextProvider> providersByType;
    private final String[] allProviderTypes;
    private final DefaultValues defaultValues;
    private final ExecutorService defaultExecutorService;
    private SmallRyeThreadContext allPropagatedThreadContext;
    private SmallRyeThreadContext allClearedThreadContext;
    private final boolean enableFastThreadContextProviders;

    SmallRyeContextManager(List<ThreadContextProvider> providers, List<ContextManagerExtension> extensions, ExecutorService defaultExecutorService, boolean registerOnProvider, ClassLoader registrationClassLoader, boolean enableFastThreadContextProviders) {
        this.defaultExecutorService = defaultExecutorService;
        this.enableFastThreadContextProviders = enableFastThreadContextProviders;
        ArrayList<ThreadContextProvider> providersCopy = new ArrayList<ThreadContextProvider>(providers);
        this.providersByType = new HashMap<String, ThreadContextProvider>();
        for (ThreadContextProvider provider : providers) {
            String type = provider.getThreadContextType();
            if (this.providersByType.containsKey(type)) {
                throw new IllegalStateException("ThreadContextProvider type already registered: " + type + " first instance: " + this.providersByType.get(type) + ", second instance: " + provider);
            }
            this.providersByType.put(type, provider);
        }
        this.allProviderTypes = this.providersByType.keySet().toArray(new String[providersCopy.size()]);
        this.extensions = new ArrayList<ContextManagerExtension>(extensions);
        this.defaultValues = new DefaultValues();
        if (registerOnProvider) {
            SmallRyeContextManagerProvider.instance().registerContextManager(this, registrationClassLoader);
        }
        for (ContextManagerExtension extension : extensions) {
            extension.setup(this);
        }
    }

    public String[] getAllProviderTypes() {
        return this.allProviderTypes;
    }

    public ThreadContextProviderPlan getProviderPlan() {
        return this.getProviderPlan(this.allProviderTypes, NO_STRING, NO_STRING);
    }

    private Set<String> createContextSetFromStringArray(String[] arrayOfContexts) {
        HashSet<String> result = new HashSet<String>();
        boolean noneUsed = false;
        for (String context : arrayOfContexts) {
            if (context.equals(NONE)) {
                noneUsed = true;
                continue;
            }
            result.add(context);
        }
        if (noneUsed && result.size() > 0) {
            throw new IllegalStateException("Cannot use 'None' in conjunction with any other contexts, the offending context declaration used: " + Arrays.toString(arrayOfContexts));
        }
        return result;
    }

    public ThreadContextProviderPlan getProviderPlan(String[] propagated, String[] unchanged, String[] cleared) {
        Set<String> propagatedSet = this.createContextSetFromStringArray(propagated);
        Set<String> clearedSet = this.createContextSetFromStringArray(cleared);
        Set<String> unchangedSet = this.createContextSetFromStringArray(unchanged);
        if (propagatedSet.removeAll(unchangedSet) || propagatedSet.removeAll(clearedSet) || clearedSet.removeAll(propagatedSet) || clearedSet.removeAll(unchangedSet) || unchangedSet.removeAll(propagatedSet) || unchangedSet.removeAll(clearedSet)) {
            throw new IllegalStateException("Cannot use the same context in more than one of propagated (" + Arrays.toString(propagated) + "), cleared (" + Arrays.toString(cleared) + "), unchanged (" + Arrays.toString(unchanged) + ")");
        }
        boolean hadAllRemaining = false;
        if (propagatedSet.contains("Remaining")) {
            propagatedSet.remove("Remaining");
            Collections.addAll(propagatedSet, this.allProviderTypes);
            propagatedSet.removeAll(clearedSet);
            propagatedSet.removeAll(unchangedSet);
            hadAllRemaining = true;
        }
        if (unchangedSet.contains("Remaining")) {
            unchangedSet.remove("Remaining");
            Collections.addAll(unchangedSet, this.allProviderTypes);
            unchangedSet.removeAll(propagatedSet);
            unchangedSet.removeAll(clearedSet);
            hadAllRemaining = true;
        }
        if (clearedSet.contains("Remaining") || !hadAllRemaining) {
            clearedSet.remove("Remaining");
            Collections.addAll(clearedSet, this.allProviderTypes);
            clearedSet.removeAll(propagatedSet);
            clearedSet.removeAll(unchangedSet);
        }
        HashSet<ThreadContextProvider> propagatedProviders = new HashSet<ThreadContextProvider>();
        for (String string : propagatedSet) {
            if (string.isEmpty()) continue;
            ThreadContextProvider provider = this.providersByType.get(string);
            if (provider == null) {
                throw new IllegalStateException("Missing propagated provider type: " + string);
            }
            propagatedProviders.add(provider);
        }
        HashSet<ThreadContextProvider> unchangedProviders = new HashSet<ThreadContextProvider>();
        for (String type : unchangedSet) {
            ThreadContextProvider provider;
            if (type.isEmpty() || (provider = this.providersByType.get(type)) == null) continue;
            unchangedProviders.add(provider);
        }
        HashSet<ThreadContextProvider> hashSet = new HashSet<ThreadContextProvider>();
        for (String type : clearedSet) {
            ThreadContextProvider provider;
            if (type.isEmpty() || (provider = this.providersByType.get(type)) == null) continue;
            hashSet.add(provider);
        }
        return new ThreadContextProviderPlan(propagatedProviders, unchangedProviders, hashSet, this.enableFastThreadContextProviders);
    }

    @Override
    public SmallRyeManagedExecutor.Builder newManagedExecutorBuilder() {
        return new SmallRyeManagedExecutor.Builder(this);
    }

    @Override
    public SmallRyeThreadContext.Builder newThreadContextBuilder() {
        return new SmallRyeThreadContext.Builder(this);
    }

    public ExecutorService getDefaultExecutorService() {
        return this.defaultExecutorService;
    }

    public List<ContextManagerExtension> getExtensions() {
        return this.extensions;
    }

    public DefaultValues getDefaultValues() {
        return this.defaultValues;
    }

    public SmallRyeThreadContext allPropagatedThreadContext() {
        if (this.allPropagatedThreadContext == null) {
            this.allPropagatedThreadContext = this.newThreadContextBuilder().propagated("Remaining").cleared(new String[0]).unchanged(new String[0]).build();
        }
        return this.allPropagatedThreadContext;
    }

    public SmallRyeThreadContext allClearedThreadContext() {
        if (this.allClearedThreadContext == null) {
            this.allClearedThreadContext = this.newThreadContextBuilder().propagated(new String[0]).cleared("Remaining").unchanged(new String[0]).build();
        }
        return this.allClearedThreadContext;
    }

    public static class Builder
    implements ContextManager.Builder {
        private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        private boolean addDiscoveredThreadContextProviders;
        private boolean addDiscoveredContextManagerExtensions;
        private final List<ThreadContextProvider> contextProviders = new ArrayList<ThreadContextProvider>();
        private final List<ContextManagerExtension> contextManagerExtensions = new ArrayList<ContextManagerExtension>();
        private ExecutorService defaultExecutorService;
        private boolean registerOnProvider;
        private boolean enableFastThreadContextProviders = true;

        @Override
        public Builder withThreadContextProviders(ThreadContextProvider ... providers) {
            for (ThreadContextProvider contextProvider : providers) {
                this.contextProviders.add(contextProvider);
            }
            return this;
        }

        @Override
        public Builder addDiscoveredThreadContextProviders() {
            this.addDiscoveredThreadContextProviders = true;
            return this;
        }

        private List<ThreadContextProvider> discoverThreadContextProviders() {
            ArrayList<ThreadContextProvider> discoveredThreadContextProviders = new ArrayList<ThreadContextProvider>();
            ServiceLoader<ThreadContextProvider> configSourceLoader = ServiceLoader.load(ThreadContextProvider.class, this.classLoader);
            configSourceLoader.forEach(configSource -> discoveredThreadContextProviders.add((ThreadContextProvider)configSource));
            return discoveredThreadContextProviders;
        }

        @Override
        public Builder withContextManagerExtensions(ContextManagerExtension ... propagators) {
            for (ContextManagerExtension contextPropagator : propagators) {
                this.contextManagerExtensions.add(contextPropagator);
            }
            return this;
        }

        @Override
        public Builder addDiscoveredContextManagerExtensions() {
            this.addDiscoveredContextManagerExtensions = true;
            return this;
        }

        private List<ContextManagerExtension> discoverContextManagerExtensions() {
            ArrayList<ContextManagerExtension> discoveredContextManagerExtensions = new ArrayList<ContextManagerExtension>();
            ServiceLoader<ContextManagerExtension> configSourceLoader = ServiceLoader.load(ContextManagerExtension.class, this.classLoader);
            configSourceLoader.forEach(configSource -> discoveredContextManagerExtensions.add((ContextManagerExtension)configSource));
            return discoveredContextManagerExtensions;
        }

        @Override
        public Builder forClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
            return this;
        }

        @Override
        public SmallRyeContextManager build() {
            if (this.addDiscoveredThreadContextProviders) {
                this.contextProviders.addAll(this.discoverThreadContextProviders());
            }
            if (this.addDiscoveredContextManagerExtensions) {
                this.contextManagerExtensions.addAll(this.discoverContextManagerExtensions());
            }
            return new SmallRyeContextManager(this.contextProviders, this.contextManagerExtensions, this.defaultExecutorService, this.registerOnProvider, this.classLoader, this.enableFastThreadContextProviders);
        }

        public Builder registerOnProvider() {
            this.registerOnProvider = true;
            return this;
        }

        @Override
        public Builder withDefaultExecutorService(ExecutorService executorService) {
            this.defaultExecutorService = executorService;
            return this;
        }

        public Builder enableFastThreadContextProviders(boolean enable) {
            this.enableFastThreadContextProviders = enable;
            return this;
        }
    }
}

