/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.context;

import io.smallrye.context.SmallRyeThreadContext;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import java.util.concurrent.CompletableFuture;
import java.util.function.UnaryOperator;
import org.eclipse.microprofile.context.spi.ContextManager;
import org.eclipse.microprofile.context.spi.ContextManagerExtension;

public class MutinyContextManagerExtension
implements ContextManagerExtension {
    @Override
    public void setup(ContextManager manager) {
        Infrastructure.setCompletableFutureWrapper(new UnaryOperator<CompletableFuture<?>>(){

            @Override
            public CompletableFuture<?> apply(CompletableFuture<?> t) {
                SmallRyeThreadContext threadContext = SmallRyeThreadContext.getCurrentThreadContextOrPropagatedContexts();
                return threadContext.withContextCapture(t);
            }
        });
    }
}

