/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi.builders;

import io.smallrye.mutiny.CompositeException;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.AbstractMulti;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;

public class ResourceMulti<R, I>
extends AbstractMulti<I> {
    private final Supplier<? extends R> resourceSupplier;
    private final Function<? super R, ? extends Publisher<I>> streamSupplier;
    private final Function<? super R, Uni<Void>> onCompletion;
    private final BiFunction<? super R, ? super Throwable, Uni<Void>> onFailure;
    private final Function<? super R, Uni<Void>> onCancellation;

    public ResourceMulti(Supplier<? extends R> resourceSupplier, Function<? super R, ? extends Publisher<I>> streamSupplier, Function<? super R, Uni<Void>> onCompletion, BiFunction<? super R, ? super Throwable, Uni<Void>> onFailure, Function<? super R, Uni<Void>> onCancellation) {
        this.resourceSupplier = resourceSupplier;
        this.streamSupplier = streamSupplier;
        this.onCompletion = onCompletion;
        this.onFailure = onFailure;
        this.onCancellation = onCancellation;
    }

    @Override
    public void subscribe(MultiSubscriber<? super I> subscriber) {
        Publisher<I> stream;
        R resource;
        try {
            resource = this.resourceSupplier.get();
            if (resource == null) {
                throw new IllegalArgumentException("The supplier returned `null`");
            }
        }
        catch (Throwable e) {
            Subscriptions.fail(subscriber, e);
            return;
        }
        try {
            stream = this.streamSupplier.apply(resource);
            if (stream == null) {
                throw new IllegalArgumentException("The supplier returned `null`");
            }
        }
        catch (Throwable e) {
            try {
                Uni<Void> uni = this.onFailure.apply(resource, e);
                if (uni == null) {
                    Subscriptions.fail(subscriber, new NullPointerException("Unable to call the finalizer - it returned `null`"));
                } else {
                    uni.subscribe().with(completed -> Subscriptions.fail(subscriber, e), failed -> Subscriptions.fail(subscriber, new CompositeException(e, (Throwable)failed)));
                }
            }
            catch (Throwable ex) {
                Subscriptions.fail(subscriber, new CompositeException(e, ex));
                return;
            }
            Subscriptions.fail(subscriber, e);
            return;
        }
        ResourceSubscriber<? super I, ? super R> us = new ResourceSubscriber<I, R>(subscriber, resource, this.onCompletion, this.onFailure, this.onCancellation);
        stream.subscribe(us);
    }

    private static class ResourceSubscriber<I, R>
    implements Subscription,
    MultiSubscriber<I> {
        private final MultiSubscriber<? super I> downstream;
        private final R resource;
        private final Function<? super R, Uni<Void>> onCompletion;
        private final BiFunction<? super R, ? super Throwable, Uni<Void>> onFailure;
        private final Function<? super R, Uni<Void>> onCancellation;
        private final AtomicBoolean terminated = new AtomicBoolean();
        private final AtomicReference<Subscription> upstream = new AtomicReference();

        public ResourceSubscriber(MultiSubscriber<? super I> downstream, R resource, Function<? super R, Uni<Void>> onCompletion, BiFunction<? super R, ? super Throwable, Uni<Void>> onFailure, Function<? super R, Uni<Void>> onCancellation) {
            this.downstream = downstream;
            this.resource = resource;
            this.onCompletion = onCompletion;
            this.onFailure = onFailure;
            this.onCancellation = onCancellation;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (this.upstream.compareAndSet(null, s)) {
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onItem(I item) {
            this.downstream.onNext(item);
        }

        @Override
        public void onFailure(Throwable failure) {
            Throwable innerError = null;
            Uni<Void> uni = null;
            if (this.terminated.compareAndSet(false, true)) {
                try {
                    uni = this.onFailure.apply(this.resource, failure);
                    if (uni == null) {
                        throw new NullPointerException("The finalizer produced a `null` Uni");
                    }
                }
                catch (Throwable e) {
                    innerError = e;
                }
            }
            Subscriptions.cancel(this.upstream);
            if (innerError != null) {
                this.downstream.onFailure(new CompositeException(failure, innerError));
            } else if (uni != null) {
                uni.subscribe().with(completed -> this.downstream.onFailure(failure), failed -> this.downstream.onFailure(new CompositeException(failure, (Throwable)failed)));
            }
        }

        @Override
        public void onCompletion() {
            Throwable innerError = null;
            Uni<Void> uni = null;
            if (this.terminated.compareAndSet(false, true)) {
                try {
                    uni = this.onCompletion.apply(this.resource);
                    if (uni == null) {
                        throw new NullPointerException("The finalizer produced a `null` Uni");
                    }
                }
                catch (Throwable e) {
                    innerError = e;
                }
            }
            Subscriptions.cancel(this.upstream);
            if (innerError != null) {
                this.downstream.onFailure(innerError);
            } else if (uni != null) {
                uni.subscribe().with(completed -> this.downstream.onCompletion(), this.downstream::onFailure);
            }
        }

        @Override
        public void request(long n) {
            this.upstream.get().request(n);
        }

        @Override
        public void cancel() {
            Throwable innerError = null;
            Uni<Void> uni = null;
            if (this.terminated.compareAndSet(false, true)) {
                try {
                    uni = this.onCancellation.apply(this.resource);
                    if (uni == null) {
                        throw new NullPointerException("The finalizer produced a `null` Uni");
                    }
                }
                catch (Throwable e) {
                    innerError = e;
                }
            }
            Subscriptions.cancel(this.upstream);
            if (innerError != null) {
                this.downstream.onFailure(innerError);
            } else if (uni != null) {
                uni.subscribe().with(completed -> {}, Infrastructure::handleDroppedException);
            }
        }
    }
}

