/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner.dataobject;

import io.smallrye.openapi.api.constants.JacksonConstants;
import io.smallrye.openapi.runtime.scanner.dataobject.DataObjectLogging;
import io.smallrye.openapi.runtime.util.JandexUtil;
import io.smallrye.openapi.runtime.util.TypeUtil;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;

public class BeanValidationScanner {
    static final BeanValidationScanner INSTANCE = new BeanValidationScanner();
    static final Set<DotName> CONSTRAINTS = new HashSet<DotName>();
    static final BigDecimal NEGATIVE_ONE = BigDecimal.ZERO.subtract(BigDecimal.ONE);
    static final DotName BV_JAVAX = DotName.createComponentized(null, "javax");
    static final DotName BV_JAKARTA = DotName.createComponentized(null, "jakarta");
    static final DotName BV_JAVAX_BASE = DotName.createComponentized(BV_JAVAX, "validation");
    static final DotName BV_JAKARTA_BASE = DotName.createComponentized(BV_JAKARTA, "validation");
    static final DotName BV_JAVAX_GROUPS = DotName.createComponentized(BV_JAVAX_BASE, "groups");
    static final DotName BV_JAKARTA_GROUPS = DotName.createComponentized(BV_JAKARTA_BASE, "groups");
    static final DotName BV_JAVAX_DEFAULT_GROUP = DotName.createComponentized(BV_JAVAX_GROUPS, "Default");
    static final DotName BV_JAKARTA_DEFAULT_GROUP = DotName.createComponentized(BV_JAKARTA_GROUPS, "Default");
    static final DotName BV_JAVAX_CONTRAINTS = DotName.createComponentized(BV_JAVAX_BASE, "constraints");
    static final DotName BV_JAKARTA_CONTRAINTS = DotName.createComponentized(BV_JAKARTA_BASE, "constraints");
    static final List<DotName> BV_DECIMAL_MAX = Arrays.asList(BeanValidationScanner.createConstraintName(BV_JAVAX_CONTRAINTS, "DecimalMax"), BeanValidationScanner.createConstraintName(BV_JAKARTA_CONTRAINTS, "DecimalMax"));
    static final List<DotName> BV_DECIMAL_MIN = Arrays.asList(BeanValidationScanner.createConstraintName(BV_JAVAX_CONTRAINTS, "DecimalMin"), BeanValidationScanner.createConstraintName(BV_JAKARTA_CONTRAINTS, "DecimalMin"));
    static final List<DotName> BV_DIGITS = Arrays.asList(BeanValidationScanner.createConstraintName(BV_JAVAX_CONTRAINTS, "Digits"), BeanValidationScanner.createConstraintName(BV_JAKARTA_CONTRAINTS, "Digits"));
    static final List<DotName> BV_MAX = Arrays.asList(BeanValidationScanner.createConstraintName(BV_JAVAX_CONTRAINTS, "Max"), BeanValidationScanner.createConstraintName(BV_JAKARTA_CONTRAINTS, "Max"));
    static final List<DotName> BV_MIN = Arrays.asList(BeanValidationScanner.createConstraintName(BV_JAVAX_CONTRAINTS, "Min"), BeanValidationScanner.createConstraintName(BV_JAKARTA_CONTRAINTS, "Min"));
    static final List<DotName> BV_NEGATIVE = Arrays.asList(BeanValidationScanner.createConstraintName(BV_JAVAX_CONTRAINTS, "Negative"), BeanValidationScanner.createConstraintName(BV_JAKARTA_CONTRAINTS, "Negative"));
    static final List<DotName> BV_NEGATIVE_OR_ZERO = Arrays.asList(BeanValidationScanner.createConstraintName(BV_JAVAX_CONTRAINTS, "NegativeOrZero"), BeanValidationScanner.createConstraintName(BV_JAKARTA_CONTRAINTS, "NegativeOrZero"));
    static final List<DotName> BV_NOT_BLANK = Arrays.asList(BeanValidationScanner.createConstraintName(BV_JAVAX_CONTRAINTS, "NotBlank"), BeanValidationScanner.createConstraintName(BV_JAKARTA_CONTRAINTS, "NotBlank"));
    static final List<DotName> BV_NOT_EMPTY = Arrays.asList(BeanValidationScanner.createConstraintName(BV_JAVAX_CONTRAINTS, "NotEmpty"), BeanValidationScanner.createConstraintName(BV_JAKARTA_CONTRAINTS, "NotEmpty"));
    static final List<DotName> BV_NOT_NULL = Arrays.asList(BeanValidationScanner.createConstraintName(BV_JAVAX_CONTRAINTS, "NotNull"), BeanValidationScanner.createConstraintName(BV_JAKARTA_CONTRAINTS, "NotNull"));
    static final List<DotName> BV_POSITIVE = Arrays.asList(BeanValidationScanner.createConstraintName(BV_JAVAX_CONTRAINTS, "Positive"), BeanValidationScanner.createConstraintName(BV_JAKARTA_CONTRAINTS, "Positive"));
    static final List<DotName> BV_POSITIVE_OR_ZERO = Arrays.asList(BeanValidationScanner.createConstraintName(BV_JAVAX_CONTRAINTS, "PositiveOrZero"), BeanValidationScanner.createConstraintName(BV_JAKARTA_CONTRAINTS, "PositiveOrZero"));
    static final List<DotName> BV_SIZE = Arrays.asList(BeanValidationScanner.createConstraintName(BV_JAVAX_CONTRAINTS, "Size"), BeanValidationScanner.createConstraintName(BV_JAKARTA_CONTRAINTS, "Size"));
    static final DotName JACKSON_JSONPROPERTY = BeanValidationScanner.createConstraintName(JacksonConstants.JSON_PROPERTY);
    private static final String VALUE = "value";
    private static final String INCLUSIVE = "inclusive";

    static DotName createConstraintName(DotName packageName, String className) {
        return BeanValidationScanner.createConstraintName(DotName.createComponentized(packageName, className));
    }

    static DotName createConstraintName(DotName constraintName) {
        CONSTRAINTS.add(constraintName);
        return constraintName;
    }

    public static boolean hasConstraints(AnnotationTarget target) {
        return TypeUtil.getAnnotations(target).stream().map(AnnotationInstance::name).anyMatch(CONSTRAINTS::contains);
    }

    public static void applyConstraints(AnnotationTarget target, Schema schema, String propertyKey, RequirementHandler handler) {
        Schema.SchemaType schemaType = schema.getType();
        if (schemaType == null || schema.getRef() != null) {
            return;
        }
        switch (schemaType) {
            case ARRAY: {
                BeanValidationScanner.applyArrayConstraints(target, schema, propertyKey, handler);
                break;
            }
            case BOOLEAN: {
                INSTANCE.notNull(target, schema, propertyKey, handler);
                INSTANCE.requiredJackson(target, propertyKey, handler);
                break;
            }
            case INTEGER: {
                BeanValidationScanner.applyNumberConstraints(target, schema, propertyKey, handler);
                break;
            }
            case NUMBER: {
                BeanValidationScanner.applyNumberConstraints(target, schema, propertyKey, handler);
                break;
            }
            case OBJECT: {
                BeanValidationScanner.applyObjectConstraints(target, schema, propertyKey, handler);
                break;
            }
            case STRING: {
                BeanValidationScanner.applyStringConstraints(target, schema, propertyKey, handler);
            }
        }
    }

    private static void applyStringConstraints(AnnotationTarget target, Schema schema, String propertyKey, RequirementHandler handler) {
        INSTANCE.decimalMax(target, schema);
        INSTANCE.decimalMin(target, schema);
        INSTANCE.digits(target, schema);
        INSTANCE.notBlank(target, schema, propertyKey, handler);
        INSTANCE.notNull(target, schema, propertyKey, handler);
        INSTANCE.requiredJackson(target, propertyKey, handler);
        INSTANCE.sizeString(target, schema);
        INSTANCE.notEmptyString(target, schema, propertyKey, handler);
    }

    private static void applyObjectConstraints(AnnotationTarget target, Schema schema, String propertyKey, RequirementHandler handler) {
        INSTANCE.notNull(target, schema, propertyKey, handler);
        INSTANCE.requiredJackson(target, propertyKey, handler);
        INSTANCE.sizeObject(target, schema);
        INSTANCE.notEmptyObject(target, schema, propertyKey, handler);
    }

    private static void applyArrayConstraints(AnnotationTarget target, Schema schema, String propertyKey, RequirementHandler handler) {
        INSTANCE.notNull(target, schema, propertyKey, handler);
        INSTANCE.requiredJackson(target, propertyKey, handler);
        INSTANCE.sizeArray(target, schema);
        INSTANCE.notEmptyArray(target, schema, propertyKey, handler);
    }

    private static void applyNumberConstraints(AnnotationTarget target, Schema schema, String propertyKey, RequirementHandler handler) {
        INSTANCE.decimalMax(target, schema);
        INSTANCE.decimalMin(target, schema);
        INSTANCE.digits(target, schema);
        INSTANCE.max(target, schema);
        INSTANCE.min(target, schema);
        INSTANCE.negative(target, schema);
        INSTANCE.negativeOrZero(target, schema);
        INSTANCE.notNull(target, schema, propertyKey, handler);
        INSTANCE.requiredJackson(target, propertyKey, handler);
        INSTANCE.positive(target, schema);
        INSTANCE.positiveOrZero(target, schema);
    }

    void decimalMax(AnnotationTarget target, Schema schema) {
        AnnotationInstance constraint = this.getConstraint(target, BV_DECIMAL_MAX);
        if (constraint != null && schema.getMaximum() == null) {
            String decimalValue = JandexUtil.stringValue(constraint, VALUE);
            try {
                BigDecimal decimal = new BigDecimal(decimalValue);
                schema.setMaximum(decimal);
                Optional<Boolean> inclusive = JandexUtil.booleanValue(constraint, INCLUSIVE);
                if (schema.getExclusiveMaximum() == null && inclusive.isPresent() && !inclusive.get().booleanValue()) {
                    schema.setExclusiveMaximum(Boolean.TRUE);
                }
            }
            catch (NumberFormatException e) {
                DataObjectLogging.logger.invalidAnnotationFormat(decimalValue);
            }
        }
    }

    void decimalMin(AnnotationTarget target, Schema schema) {
        AnnotationInstance constraint = this.getConstraint(target, BV_DECIMAL_MIN);
        if (constraint != null && schema.getMinimum() == null) {
            String decimalValue = JandexUtil.stringValue(constraint, VALUE);
            try {
                BigDecimal decimal = new BigDecimal(decimalValue);
                schema.setMinimum(decimal);
                Optional<Boolean> inclusive = JandexUtil.booleanValue(constraint, INCLUSIVE);
                if (schema.getExclusiveMinimum() == null && inclusive.isPresent() && !inclusive.get().booleanValue()) {
                    schema.setExclusiveMinimum(Boolean.TRUE);
                }
            }
            catch (NumberFormatException e) {
                DataObjectLogging.logger.invalidAnnotationFormat(decimalValue);
            }
        }
    }

    void digits(AnnotationTarget target, Schema schema) {
        AnnotationInstance constraint = this.getConstraint(target, BV_DIGITS);
        if (constraint != null && schema.getPattern() == null) {
            int integerPart = JandexUtil.intValue(constraint, "integer");
            int fractionPart = JandexUtil.intValue(constraint, "fraction");
            StringBuilder pattern = new StringBuilder(50);
            pattern.append('^');
            if (integerPart > 0) {
                pattern.append("\\d");
                if (integerPart > 1) {
                    pattern.append("{1,").append(integerPart).append('}');
                }
            }
            if (fractionPart > 0) {
                pattern.append("([.]\\d");
                if (fractionPart > 1) {
                    pattern.append("{1,").append(fractionPart).append("}");
                }
                pattern.append(")?");
            }
            pattern.append('$');
            schema.setPattern(pattern.toString());
        }
    }

    void max(AnnotationTarget target, Schema schema) {
        AnnotationInstance constraint = this.getConstraint(target, BV_MAX);
        if (constraint != null && schema.getMaximum() == null) {
            AnnotationValue value = constraint.value(VALUE);
            schema.setMaximum(new BigDecimal(value.asLong()));
        }
    }

    void min(AnnotationTarget target, Schema schema) {
        AnnotationInstance constraint = this.getConstraint(target, BV_MIN);
        if (constraint != null && schema.getMinimum() == null) {
            AnnotationValue value = constraint.value(VALUE);
            schema.setMinimum(new BigDecimal(value.asLong()));
        }
    }

    void negative(AnnotationTarget target, Schema schema) {
        AnnotationInstance constraint = this.getConstraint(target, BV_NEGATIVE);
        if (constraint != null && schema.getMaximum() == null) {
            Boolean exclusive = schema.getExclusiveMaximum();
            if (exclusive != null && exclusive.booleanValue()) {
                schema.setMaximum(BigDecimal.ZERO);
            } else {
                schema.setMaximum(NEGATIVE_ONE);
            }
        }
    }

    void negativeOrZero(AnnotationTarget target, Schema schema) {
        AnnotationInstance constraint = this.getConstraint(target, BV_NEGATIVE_OR_ZERO);
        if (constraint != null && schema.getMaximum() == null) {
            Boolean exclusive = schema.getExclusiveMaximum();
            if (exclusive != null && exclusive.booleanValue()) {
                schema.setMaximum(BigDecimal.ONE);
            } else {
                schema.setMaximum(BigDecimal.ZERO);
            }
        }
    }

    void notBlank(AnnotationTarget target, Schema schema, String propertyKey, RequirementHandler handler) {
        AnnotationInstance constraint = this.getConstraint(target, BV_NOT_BLANK);
        if (constraint != null) {
            if (schema.getNullable() == null) {
                schema.setNullable(Boolean.FALSE);
            }
            if (schema.getPattern() == null) {
                schema.setPattern("\\S");
            }
            handler.setRequired(target, propertyKey);
        }
    }

    void notEmptyArray(AnnotationTarget target, Schema schema, String propertyKey, RequirementHandler handler) {
        AnnotationInstance constraint = this.getConstraint(target, BV_NOT_EMPTY);
        if (constraint != null) {
            if (schema.getMinItems() == null) {
                schema.setMinItems(1);
            }
            handler.setRequired(target, propertyKey);
        }
    }

    void notEmptyObject(AnnotationTarget target, Schema schema, String propertyKey, RequirementHandler handler) {
        if (!this.allowsAdditionalProperties(schema)) {
            return;
        }
        AnnotationInstance constraint = this.getConstraint(target, BV_NOT_EMPTY);
        if (constraint != null) {
            if (schema.getMinProperties() == null) {
                schema.setMinProperties(1);
            }
            handler.setRequired(target, propertyKey);
        }
    }

    void notEmptyString(AnnotationTarget target, Schema schema, String propertyKey, RequirementHandler handler) {
        AnnotationInstance constraint = this.getConstraint(target, BV_NOT_EMPTY);
        if (constraint != null) {
            if (schema.getNullable() == null) {
                schema.setNullable(Boolean.FALSE);
            }
            if (schema.getMinLength() == null) {
                schema.setMinLength(1);
            }
            handler.setRequired(target, propertyKey);
        }
    }

    void notNull(AnnotationTarget target, Schema schema, String propertyKey, RequirementHandler handler) {
        AnnotationInstance constraint = this.getConstraint(target, BV_NOT_NULL);
        if (constraint != null) {
            if (schema.getNullable() == null) {
                schema.setNullable(Boolean.FALSE);
            }
            handler.setRequired(target, propertyKey);
        }
    }

    void positive(AnnotationTarget target, Schema schema) {
        AnnotationInstance constraint = this.getConstraint(target, BV_POSITIVE);
        if (constraint != null && schema.getMinimum() == null) {
            Boolean exclusive = schema.getExclusiveMinimum();
            if (exclusive != null && exclusive.booleanValue()) {
                schema.setMinimum(BigDecimal.ZERO);
            } else {
                schema.setMinimum(BigDecimal.ONE);
            }
        }
    }

    void positiveOrZero(AnnotationTarget target, Schema schema) {
        AnnotationInstance constraint = this.getConstraint(target, BV_POSITIVE_OR_ZERO);
        if (constraint != null && schema.getMinimum() == null) {
            Boolean exclusive = schema.getExclusiveMinimum();
            if (exclusive != null && exclusive.booleanValue()) {
                schema.setMinimum(NEGATIVE_ONE);
            } else {
                schema.setMinimum(BigDecimal.ZERO);
            }
        }
    }

    void requiredJackson(AnnotationTarget target, String propertyKey, RequirementHandler handler) {
        Boolean required = (Boolean)TypeUtil.getAnnotationValue(target, JACKSON_JSONPROPERTY, "required");
        if (Boolean.TRUE.equals(required)) {
            handler.setRequired(target, propertyKey);
        }
    }

    void sizeArray(AnnotationTarget target, Schema schema) {
        AnnotationInstance constraint = this.getConstraint(target, BV_SIZE);
        if (constraint != null) {
            Integer min = JandexUtil.intValue(constraint, "min");
            Integer max = JandexUtil.intValue(constraint, "max");
            if (min != null && schema.getMinItems() == null) {
                schema.setMinItems(min);
            }
            if (max != null && schema.getMaxItems() == null) {
                schema.setMaxItems(max);
            }
        }
    }

    void sizeObject(AnnotationTarget target, Schema schema) {
        if (!this.allowsAdditionalProperties(schema)) {
            return;
        }
        AnnotationInstance constraint = this.getConstraint(target, BV_SIZE);
        if (constraint != null) {
            Integer min = JandexUtil.intValue(constraint, "min");
            Integer max = JandexUtil.intValue(constraint, "max");
            if (min != null && schema.getMinProperties() == null) {
                schema.setMinProperties(min);
            }
            if (max != null && schema.getMaxProperties() == null) {
                schema.setMaxProperties(max);
            }
        }
    }

    void sizeString(AnnotationTarget target, Schema schema) {
        AnnotationInstance constraint = this.getConstraint(target, BV_SIZE);
        if (constraint != null) {
            Integer min = JandexUtil.intValue(constraint, "min");
            Integer max = JandexUtil.intValue(constraint, "max");
            if (min != null && schema.getMinLength() == null) {
                schema.setMinLength(min);
            }
            if (max != null && schema.getMaxLength() == null) {
                schema.setMaxLength(max);
            }
        }
    }

    boolean allowsAdditionalProperties(Schema schema) {
        Boolean additionalProperties = schema.getAdditionalPropertiesBoolean();
        if (additionalProperties != null) {
            return additionalProperties;
        }
        return schema.getAdditionalPropertiesSchema() != null;
    }

    AnnotationInstance getConstraint(AnnotationTarget target, List<DotName> annotationName) {
        AnnotationInstance constraint = TypeUtil.getAnnotation(target, annotationName);
        if (constraint != null) {
            AnnotationValue groupValue = constraint.value("groups");
            if (groupValue == null) {
                return constraint;
            }
            Type[] groups = groupValue.asClassArray();
            switch (groups.length) {
                case 0: {
                    return constraint;
                }
                case 1: {
                    if (!groups[0].name().equals(BV_JAVAX_DEFAULT_GROUP) && !groups[0].name().equals(BV_JAKARTA_DEFAULT_GROUP)) break;
                    return constraint;
                }
            }
        }
        return null;
    }

    public static interface RequirementHandler {
        public void setRequired(AnnotationTarget var1, String var2);
    }
}

