/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.helpers;

import io.smallrye.mutiny.Multi;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams;
import org.reactivestreams.Publisher;

public class BroadcastHelper {
    private BroadcastHelper() {
    }

    public static PublisherBuilder<? extends Message<?>> broadcastPublisher(Publisher<? extends Message<?>> publisher, int numberOfSubscriberBeforeConnecting) {
        Multi<Message<?>> broadcastPublisher = Multi.createFrom().publisher(publisher);
        if (numberOfSubscriberBeforeConnecting != 0) {
            return ReactiveStreams.fromPublisher(broadcastPublisher.broadcast().toAtLeast(numberOfSubscriberBeforeConnecting));
        }
        return ReactiveStreams.fromPublisher(broadcastPublisher.broadcast().toAllSubscribers());
    }
}

