/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl.headers;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.impl.HttpUtils;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public final class HeadersMultiMap
extends io.netty.handler.codec.http.HttpHeaders
implements MultiMap {
    static final BiConsumer<CharSequence, CharSequence> HTTP_VALIDATOR = !HttpHeaders.DISABLE_HTTP_HEADERS_VALIDATION ? HttpUtils::validateHeader : null;
    private final BiConsumer<CharSequence, CharSequence> validator;
    private final MapEntry[] entries = new MapEntry[16];
    private final MapEntry head = new MapEntry();
    private static final int COLON_AND_SPACE_SHORT = 14880;
    static final int CRLF_SHORT = 3338;

    private static CharSequence toValidCharSequence(Object value) {
        if (value instanceof CharSequence) {
            return (CharSequence)value;
        }
        return value.toString();
    }

    public static HeadersMultiMap httpHeaders() {
        return new HeadersMultiMap(HTTP_VALIDATOR);
    }

    public static HeadersMultiMap headers() {
        return new HeadersMultiMap();
    }

    @Override
    public MultiMap setAll(MultiMap headers) {
        return this.set0(headers);
    }

    @Override
    public MultiMap setAll(Map<String, String> headers) {
        return this.set0(headers.entrySet());
    }

    @Override
    public int size() {
        return this.names().size();
    }

    public HeadersMultiMap() {
        this(null);
    }

    public HeadersMultiMap(BiConsumer<CharSequence, CharSequence> validator) {
        this.validator = validator;
        this.head.before = this.head.after = this.head;
    }

    @Override
    public HeadersMultiMap add(CharSequence name, CharSequence value) {
        Objects.requireNonNull(value);
        int h = AsciiString.hashCode(name);
        int i = h & 0xF;
        this.add0(h, i, name, value);
        return this;
    }

    @Override
    public HeadersMultiMap add(CharSequence name, Object value) {
        return this.add(name, HeadersMultiMap.toValidCharSequence(value));
    }

    @Override
    public io.netty.handler.codec.http.HttpHeaders add(String name, Object value) {
        return this.add((CharSequence)name, HeadersMultiMap.toValidCharSequence(value));
    }

    @Override
    public HeadersMultiMap add(String name, String strVal) {
        return this.add((CharSequence)name, (CharSequence)strVal);
    }

    public HeadersMultiMap add(CharSequence name, Iterable values) {
        int h = AsciiString.hashCode(name);
        int i = h & 0xF;
        for (Object vstr : values) {
            this.add0(h, i, name, HeadersMultiMap.toValidCharSequence(vstr));
        }
        return this;
    }

    public HeadersMultiMap add(String name, Iterable values) {
        return this.add((CharSequence)name, values);
    }

    @Override
    public MultiMap addAll(MultiMap headers) {
        return this.addAll(headers.entries());
    }

    @Override
    public MultiMap addAll(Map<String, String> map) {
        return this.addAll(map.entrySet());
    }

    private MultiMap addAll(Iterable<Map.Entry<String, String>> headers) {
        for (Map.Entry<String, String> entry : headers) {
            this.add(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public HeadersMultiMap remove(CharSequence name) {
        Objects.requireNonNull(name, "name");
        int h = AsciiString.hashCode(name);
        int i = h & 0xF;
        this.remove0(h, i, name);
        return this;
    }

    @Override
    public HeadersMultiMap remove(String name) {
        return this.remove((CharSequence)name);
    }

    @Override
    public HeadersMultiMap set(CharSequence name, CharSequence value) {
        return this.set0(name, value);
    }

    @Override
    public HeadersMultiMap set(String name, String value) {
        return this.set((CharSequence)name, (CharSequence)value);
    }

    @Override
    public HeadersMultiMap set(String name, Object value) {
        return this.set((CharSequence)name, HeadersMultiMap.toValidCharSequence(value));
    }

    @Override
    public HeadersMultiMap set(CharSequence name, Object value) {
        return this.set(name, HeadersMultiMap.toValidCharSequence(value));
    }

    public HeadersMultiMap set(CharSequence name, Iterable values) {
        Objects.requireNonNull(values, "values");
        int h = AsciiString.hashCode(name);
        int i = h & 0xF;
        this.remove0(h, i, name);
        for (Object v : values) {
            if (v == null) break;
            this.add0(h, i, name, HeadersMultiMap.toValidCharSequence(v));
        }
        return this;
    }

    public HeadersMultiMap set(String name, Iterable values) {
        return this.set((CharSequence)name, values);
    }

    @Override
    public boolean containsValue(CharSequence name, CharSequence value, boolean ignoreCase) {
        return this.containsInternal(name, value, false, ignoreCase);
    }

    @Override
    public boolean contains(CharSequence name, CharSequence value, boolean ignoreCase) {
        return this.containsInternal(name, value, true, ignoreCase);
    }

    private boolean containsInternal(CharSequence name, CharSequence value, boolean equals, boolean ignoreCase) {
        int h = AsciiString.hashCode(name);
        int i = h & 0xF;
        MapEntry e = this.entries[i];
        while (e != null) {
            CharSequence key = e.key;
            if (e.hash == h && (name == key || AsciiString.contentEqualsIgnoreCase(name, key))) {
                CharSequence other = e.getValue();
                if (equals) {
                    if (ignoreCase && AsciiString.contentEqualsIgnoreCase(value, other) || !ignoreCase && AsciiString.contentEquals(value, other)) {
                        return true;
                    }
                } else {
                    int prev = 0;
                    while (true) {
                        int idx;
                        int from;
                        int to;
                        for (to = (idx = AsciiString.indexOf(other, ',', prev)) == -1 ? other.length() : idx; to > prev && other.charAt(to - 1) == ' '; --to) {
                        }
                        for (from = prev; from < to && other.charAt(from) == ' '; ++from) {
                        }
                        int len = to - from;
                        if (len > 0 && AsciiString.regionMatches(other, ignoreCase, from, value, 0, len)) {
                            return true;
                        }
                        if (idx == -1) break;
                        prev = idx + 1;
                    }
                }
            }
            e = e.next;
        }
        return false;
    }

    @Override
    public boolean contains(String name, String value, boolean ignoreCase) {
        return this.contains((CharSequence)name, (CharSequence)value, ignoreCase);
    }

    @Override
    public boolean contains(CharSequence name) {
        return this.get0(name) != null;
    }

    @Override
    public boolean contains(String name) {
        return this.contains((CharSequence)name);
    }

    @Override
    public String get(CharSequence name) {
        Objects.requireNonNull(name, "name");
        CharSequence ret = this.get0(name);
        return ret != null ? ret.toString() : null;
    }

    @Override
    public String get(String name) {
        return this.get((CharSequence)name);
    }

    @Override
    public List<String> getAll(CharSequence name) {
        Objects.requireNonNull(name, "name");
        LinkedList<String> values = new LinkedList<String>();
        int h = AsciiString.hashCode(name);
        int i = h & 0xF;
        MapEntry e = this.entries[i];
        while (e != null) {
            CharSequence key = e.key;
            if (e.hash == h && (name == key || AsciiString.contentEqualsIgnoreCase(name, key))) {
                values.addFirst(e.getValue().toString());
            }
            e = e.next;
        }
        return values;
    }

    @Override
    public List<String> getAll(String name) {
        return this.getAll((CharSequence)name);
    }

    @Override
    public void forEach(Consumer<? super Map.Entry<String, String>> action) {
        MapEntry e = this.head.after;
        while (e != this.head) {
            action.accept(new AbstractMap.SimpleEntry<String, String>(e.key.toString(), e.value.toString()));
            e = e.after;
        }
    }

    @Override
    public List<Map.Entry<String, String>> entries() {
        return MultiMap.super.entries();
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        return new Iterator<Map.Entry<String, String>>(){
            MapEntry curr;
            {
                this.curr = HeadersMultiMap.this.head;
            }

            @Override
            public boolean hasNext() {
                return this.curr.after != HeadersMultiMap.this.head;
            }

            @Override
            public Map.Entry<String, String> next() {
                final MapEntry next = this.curr.after;
                if (next == HeadersMultiMap.this.head) {
                    throw new NoSuchElementException();
                }
                this.curr = next;
                return new Map.Entry<String, String>(){

                    @Override
                    public String getKey() {
                        return next.key.toString();
                    }

                    @Override
                    public String getValue() {
                        return next.value.toString();
                    }

                    @Override
                    public String setValue(String value) {
                        return next.setValue(value).toString();
                    }

                    public String toString() {
                        return this.getKey() + "=" + this.getValue();
                    }
                };
            }
        };
    }

    @Override
    public boolean isEmpty() {
        return this.head == this.head.after;
    }

    @Override
    public Set<String> names() {
        TreeSet<String> names = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        MapEntry e = this.head.after;
        while (e != this.head) {
            names.add(e.getKey().toString());
            e = e.after;
        }
        return names;
    }

    @Override
    public HeadersMultiMap clear() {
        Arrays.fill(this.entries, null);
        this.head.before = this.head.after = this.head;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : this) {
            sb.append(entry).append('\n');
        }
        return sb.toString();
    }

    @Override
    public Integer getInt(CharSequence name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getInt(CharSequence name, int defaultValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Short getShort(CharSequence name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public short getShort(CharSequence name, short defaultValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long getTimeMillis(CharSequence name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getTimeMillis(CharSequence name, long defaultValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Map.Entry<CharSequence, CharSequence>> iteratorCharSequence() {
        return new Iterator<Map.Entry<CharSequence, CharSequence>>(){
            MapEntry current;
            {
                this.current = ((HeadersMultiMap)HeadersMultiMap.this).head.after;
            }

            @Override
            public boolean hasNext() {
                return this.current != HeadersMultiMap.this.head;
            }

            @Override
            public Map.Entry<CharSequence, CharSequence> next() {
                MapEntry next = this.current;
                this.current = this.current.after;
                return next;
            }
        };
    }

    @Override
    public io.netty.handler.codec.http.HttpHeaders addInt(CharSequence name, int value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public io.netty.handler.codec.http.HttpHeaders addShort(CharSequence name, short value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public io.netty.handler.codec.http.HttpHeaders setInt(CharSequence name, int value) {
        return this.set(name, (CharSequence)Integer.toString(value));
    }

    @Override
    public io.netty.handler.codec.http.HttpHeaders setShort(CharSequence name, short value) {
        throw new UnsupportedOperationException();
    }

    public void encode(ByteBuf buf) {
        MapEntry current = this.head.after;
        while (current != this.head) {
            HeadersMultiMap.encoderHeader(current.key, current.value, buf);
            current = current.after;
        }
    }

    static void encoderHeader(CharSequence name, CharSequence value, ByteBuf buf) {
        int nameLen = name.length();
        int valueLen = value.length();
        int entryLen = nameLen + valueLen + 4;
        buf.ensureWritable(entryLen);
        int offset = buf.writerIndex();
        HeadersMultiMap.writeAscii(buf, offset, name);
        ByteBufUtil.setShortBE(buf, offset += nameLen, 14880);
        HeadersMultiMap.writeAscii(buf, offset += 2, value);
        ByteBufUtil.setShortBE(buf, offset += valueLen, 3338);
        buf.writerIndex(offset += 2);
    }

    private static void writeAscii(ByteBuf buf, int offset, CharSequence value) {
        if (value instanceof AsciiString) {
            ByteBufUtil.copy((AsciiString)value, 0, buf, offset, value.length());
        } else {
            buf.setCharSequence(offset, value, CharsetUtil.US_ASCII);
        }
    }

    private void remove0(int h, int i, CharSequence name) {
        MapEntry e = this.entries[i];
        MapEntry prev = null;
        while (e != null) {
            MapEntry next = e.next;
            CharSequence key = e.key;
            if (e.hash == h && (name == key || AsciiString.contentEqualsIgnoreCase(name, key))) {
                if (prev == null) {
                    this.entries[i] = next;
                } else {
                    prev.next = next;
                }
                e.remove();
            } else {
                prev = e;
            }
            e = next;
        }
    }

    private void add0(int h, int i, CharSequence name, CharSequence value) {
        MapEntry newEntry;
        if (this.validator != null) {
            this.validator.accept(name, value);
        }
        MapEntry e = this.entries[i];
        this.entries[i] = newEntry = new MapEntry(h, name, value);
        newEntry.next = e;
        newEntry.addBefore(this.head);
    }

    private HeadersMultiMap set0(CharSequence name, CharSequence strVal) {
        int h = AsciiString.hashCode(name);
        int i = h & 0xF;
        this.remove0(h, i, name);
        if (strVal != null) {
            this.add0(h, i, name, strVal);
        }
        return this;
    }

    private CharSequence get0(CharSequence name) {
        int h = AsciiString.hashCode(name);
        int i = h & 0xF;
        MapEntry e = this.entries[i];
        CharSequence value = null;
        while (e != null) {
            CharSequence key = e.key;
            if (e.hash == h && (name == key || AsciiString.contentEqualsIgnoreCase(name, key))) {
                value = e.getValue();
            }
            e = e.next;
        }
        return value;
    }

    private MultiMap set0(Iterable<Map.Entry<String, String>> map) {
        this.clear();
        for (Map.Entry<String, String> entry : map) {
            this.add(entry.getKey(), entry.getValue());
        }
        return this;
    }

    private final class MapEntry
    implements Map.Entry<CharSequence, CharSequence> {
        final int hash;
        final CharSequence key;
        CharSequence value;
        MapEntry next;
        MapEntry before;
        MapEntry after;

        MapEntry() {
            this.hash = -1;
            this.key = null;
            this.value = null;
        }

        MapEntry(int hash, CharSequence key, CharSequence value) {
            this.hash = hash;
            this.key = key;
            this.value = value;
        }

        void remove() {
            this.before.after = this.after;
            this.after.before = this.before;
            this.after = null;
            this.before = null;
        }

        void addBefore(MapEntry e) {
            this.after = e;
            this.before = e.before;
            this.before.after = this;
            this.after.before = this;
        }

        @Override
        public CharSequence getKey() {
            return this.key;
        }

        @Override
        public CharSequence getValue() {
            return this.value;
        }

        @Override
        public CharSequence setValue(CharSequence value) {
            Objects.requireNonNull(value, "value");
            if (HeadersMultiMap.this.validator != null) {
                HeadersMultiMap.this.validator.accept("", value);
            }
            CharSequence oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }
}

