/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.tracing.typedvalue;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.kie.kogito.tracing.typedvalue.CollectionValue;
import org.kie.kogito.tracing.typedvalue.StructureValue;
import org.kie.kogito.tracing.typedvalue.UnitValue;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, defaultImpl=Kind.class, property="kind", visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=UnitValue.class, name="UNIT"), @JsonSubTypes.Type(value=CollectionValue.class, name="COLLECTION"), @JsonSubTypes.Type(value=StructureValue.class, name="STRUCTURE")})
public abstract class TypedValue {
    @JsonProperty(value="kind")
    private Kind kind;
    @JsonProperty(value="type")
    private String type;

    protected TypedValue() {
    }

    protected TypedValue(Kind kind, String type) {
        this.kind = kind;
        this.type = type;
    }

    public Kind getKind() {
        return this.kind;
    }

    public String getType() {
        return this.type;
    }

    @JsonIgnore
    public boolean isCollection() {
        return this.kind == Kind.COLLECTION;
    }

    public CollectionValue toCollection() {
        if (!this.isCollection()) {
            throw new IllegalStateException(String.format("Can't convert TypedValue of kind %s to COLLECTION", new Object[]{this.kind}));
        }
        return (CollectionValue)this;
    }

    @JsonIgnore
    public boolean isStructure() {
        return this.kind == Kind.STRUCTURE;
    }

    public StructureValue toStructure() {
        if (!this.isStructure()) {
            throw new IllegalStateException(String.format("Can't convert TypedValue of kind %s to STRUCTURE", new Object[]{this.kind}));
        }
        return (StructureValue)this;
    }

    @JsonIgnore
    public boolean isUnit() {
        return this.kind == Kind.UNIT;
    }

    public UnitValue toUnit() {
        if (!this.isUnit()) {
            throw new IllegalStateException(String.format("Can't convert TypedValue of kind %s to UNIT", new Object[]{this.kind}));
        }
        return (UnitValue)this;
    }

    public static enum Kind {
        UNIT,
        COLLECTION,
        STRUCTURE;

    }
}

