/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.service.common.messaging;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.cloudevents.CloudEvent;
import java.io.IOException;
import java.util.concurrent.CompletionStage;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.kie.kogito.cloudevents.CloudEventUtils;
import org.kie.kogito.trusty.service.common.TrustyService;
import org.kie.kogito.trusty.storage.api.StorageExceptionsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseEventConsumer<E> {
    private static final Logger LOG = LoggerFactory.getLogger(BaseEventConsumer.class);
    protected final TrustyService service;
    private final ObjectMapper mapper;
    private final StorageExceptionsProvider storageExceptionsProvider;
    @ConfigProperty(name="trusty.messaging.nack_on_any_exception", defaultValue="false")
    private boolean failOnAllExceptions;

    protected BaseEventConsumer() {
        this(null, null, null);
    }

    public BaseEventConsumer(TrustyService service, ObjectMapper mapper, StorageExceptionsProvider storageExceptionsProvider) {
        this.service = service;
        this.mapper = mapper;
        this.storageExceptionsProvider = storageExceptionsProvider;
    }

    protected CompletionStage<Void> handleMessage(Message<String> message) {
        try {
            CloudEventUtils.decode(message.getPayload()).ifPresent(this::handleCloudEvent);
        }
        catch (Exception e) {
            if (this.storageExceptionsProvider.isConnectionException(e) || this.failOnAllExceptions) {
                LOG.error("A critical exception occurred. A nack is sent and the application will react according to the specified failure strategy.", e);
                return message.nack(e);
            }
            LOG.error("Something unexpected happened during the processing of an Event. The event is discarded.", e);
        }
        return message.ack();
    }

    protected void handleCloudEvent(CloudEvent cloudEvent) {
        E payload = null;
        try {
            if (cloudEvent.getData() != null) {
                payload = this.mapper.readValue(cloudEvent.getData().toBytes(), this.getEventType());
            }
        }
        catch (IOException e) {
            LOG.error("Unable to deserialize CloudEvent data as " + this.getEventType().getType().getTypeName(), e);
            return;
        }
        if (payload == null) {
            LOG.error("Received CloudEvent with id {} from {} with empty data", (Object)cloudEvent.getId(), (Object)cloudEvent.getSource());
            return;
        }
        LOG.debug("Received CloudEvent with id {} from {}", (Object)cloudEvent.getId(), (Object)cloudEvent.getSource());
        this.internalHandleCloudEvent(cloudEvent, payload);
    }

    protected abstract TypeReference<E> getEventType();

    protected abstract void internalHandleCloudEvent(CloudEvent var1, E var2);
}

