/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.validator.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import java.lang.annotation.Annotation;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.enterprise.context.Dependent;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorFactory;
import org.hibernate.validator.internal.util.privilegedactions.NewInstance;

public class ArcConstraintValidatorFactoryImpl
implements ConstraintValidatorFactory {
    private final Map<ConstraintValidator<?, ?>, InstanceHandle<?>> destroyableConstraintValidators = new IdentityHashMap();

    @Override
    public <T extends ConstraintValidator<?, ?>> T getInstance(Class<T> key) {
        InstanceHandle<T> handle = Arc.container().instance(key, new Annotation[0]);
        if (handle.isAvailable()) {
            ConstraintValidator instance = (ConstraintValidator)handle.get();
            if (handle.getBean().getScope().equals(Dependent.class)) {
                this.destroyableConstraintValidators.put(instance, handle);
            }
            return (T)instance;
        }
        return (T)((ConstraintValidator)this.run(NewInstance.action(key, "ConstraintValidator")));
    }

    @Override
    public void releaseInstance(ConstraintValidator<?, ?> instance) {
        InstanceHandle<?> destroyableHandle = this.destroyableConstraintValidators.remove(instance);
        if (destroyableHandle != null) {
            destroyableHandle.destroy();
        }
    }

    private <T> T run(PrivilegedAction<T> action) {
        return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
    }
}

