/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.validator.runtime.jaxrs;

import java.util.Iterator;
import javax.validation.ConstraintViolation;
import javax.validation.ElementKind;
import javax.validation.Path;
import org.jboss.resteasy.api.validation.ConstraintType;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.spi.validation.ConstraintTypeUtil;

public class ConstraintTypeUtil20
implements ConstraintTypeUtil {
    @Override
    public ConstraintType.Type getConstraintType(Object o) {
        if (!(o instanceof ConstraintViolation)) {
            throw new RuntimeException(Messages.MESSAGES.unknownObjectPassedAsConstraintViolation(o));
        }
        ConstraintViolation v = (ConstraintViolation)ConstraintViolation.class.cast(o);
        Iterator nodes = v.getPropertyPath().iterator();
        Path.Node firstNode = (Path.Node)nodes.next();
        switch (firstNode.getKind()) {
            case BEAN: {
                return ConstraintType.Type.CLASS;
            }
            case CONSTRUCTOR: 
            case METHOD: {
                Path.Node secondNode = (Path.Node)nodes.next();
                if (secondNode.getKind() == ElementKind.PARAMETER || secondNode.getKind() == ElementKind.CROSS_PARAMETER) {
                    return ConstraintType.Type.PARAMETER;
                }
                if (secondNode.getKind() == ElementKind.RETURN_VALUE) {
                    return ConstraintType.Type.RETURN_VALUE;
                }
                throw new RuntimeException(Messages.MESSAGES.unexpectedPathNodeViolation(secondNode.getKind()));
            }
            case PROPERTY: {
                return ConstraintType.Type.PROPERTY;
            }
        }
        throw new RuntimeException(Messages.MESSAGES.unexpectedPathNode(firstNode.getKind()));
    }
}

