/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.openapi.runtime.filter;

import io.quarkus.smallrye.openapi.runtime.filter.AutoSecurityFilter;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.models.security.SecurityScheme;

public class AutoJWTSecurityFilter
extends AutoSecurityFilter {
    private String jwtSecuritySchemeValue;
    private String jwtBearerFormat;

    public AutoJWTSecurityFilter() {
    }

    public AutoJWTSecurityFilter(String securitySchemeName, String securitySchemeDescription, String jwtSecuritySchemeValue, String jwtBearerFormat) {
        super(securitySchemeName, securitySchemeDescription);
        this.jwtSecuritySchemeValue = jwtSecuritySchemeValue;
        this.jwtBearerFormat = jwtBearerFormat;
    }

    public String getJwtSecuritySchemeValue() {
        return this.jwtSecuritySchemeValue;
    }

    public void setJwtSecuritySchemeValue(String jwtSecuritySchemeValue) {
        this.jwtSecuritySchemeValue = jwtSecuritySchemeValue;
    }

    public String getJwtBearerFormat() {
        return this.jwtBearerFormat;
    }

    public void setJwtBearerFormat(String jwtBearerFormat) {
        this.jwtBearerFormat = jwtBearerFormat;
    }

    @Override
    protected SecurityScheme getSecurityScheme() {
        SecurityScheme securityScheme = OASFactory.createSecurityScheme();
        securityScheme.setType(SecurityScheme.Type.HTTP);
        securityScheme.setScheme(this.jwtSecuritySchemeValue);
        securityScheme.setBearerFormat(this.jwtBearerFormat);
        return securityScheme;
    }
}

