/*
 * Decompiled with CFR 0.152.
 */
package io.redisearch;

import io.redisearch.aggregation.Row;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import redis.clients.jedis.exceptions.JedisDataException;

public class AggregationResult {
    public final long totalResults;
    private long cursorId = -1L;
    private final List<Map<String, Object>> results = new ArrayList<Map<String, Object>>();

    public AggregationResult(List<Object> resp, long cursorId) {
        this(resp);
        this.cursorId = cursorId;
    }

    public AggregationResult(List<Object> resp) {
        this.totalResults = (Long)resp.get(0);
        for (int i = 1; i < resp.size(); ++i) {
            List raw = (List)resp.get(i);
            HashMap cur = new HashMap();
            for (int j = 0; j < raw.size(); j += 2) {
                Object r = raw.get(j);
                if (r instanceof JedisDataException) {
                    throw (JedisDataException)r;
                }
                cur.put(new String((byte[])r), raw.get(j + 1));
            }
            this.results.add(cur);
        }
    }

    public List<Map<String, Object>> getResults() {
        return this.results;
    }

    public Row getRow(int index) {
        if (index >= this.results.size()) {
            return null;
        }
        return new Row(this.results.get(index));
    }

    public long getCursorId() {
        return this.cursorId;
    }
}

