/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.auth.cdi;

import io.smallrye.jwt.JsonUtils;
import io.smallrye.jwt.auth.cdi.CommonJwtProducer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.Provider;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.json.JsonValue;
import org.eclipse.microprofile.jwt.ClaimValue;

public class ClaimValueWrapper<T>
implements ClaimValue<T> {
    private final CommonJwtProducer producer;
    private final String name;
    private final boolean optional;
    private final Class<?> klass;

    public ClaimValueWrapper(InjectionPoint ip, CommonJwtProducer producer) {
        this.producer = producer;
        this.name = producer.getName(ip);
        Type injectedType = ip.getType();
        if (injectedType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)injectedType;
            Type typeArgument = parameterizedType.getActualTypeArguments()[0];
            this.optional = typeArgument.getTypeName().startsWith(Optional.class.getTypeName());
        } else {
            this.optional = false;
        }
        this.klass = this.unwrapType(ip.getType(), ip);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public T getValue() {
        Object value = JsonUtils.convert(this.klass, this.producer.getValue(this.getName(), false));
        if (this.optional) {
            return (T)Optional.ofNullable(value);
        }
        return (T)value;
    }

    @Override
    public String toString() {
        T value = this.getValue();
        return String.format("ClaimValueWrapper[@%s], name=%s, value[%s]=%s", Integer.toHexString(this.hashCode()), this.name, value.getClass(), value);
    }

    private Class<?> unwrapType(Type type, InjectionPoint injectionPoint) {
        Class klass;
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            if (parameterizedType.getActualTypeArguments().length == 1) {
                Type rawType = parameterizedType.getRawType();
                Type actualType = parameterizedType.getActualTypeArguments()[0];
                if (rawType == ClaimValue.class) {
                    return this.unwrapType(actualType, injectionPoint);
                }
                if (rawType == Optional.class) {
                    return this.unwrapType(actualType, injectionPoint);
                }
                if (rawType instanceof Class && Set.class.isAssignableFrom((Class)rawType)) {
                    return (Class)rawType;
                }
                if (rawType == Provider.class || rawType == Instance.class) {
                    return this.unwrapType(actualType, injectionPoint);
                }
            }
        } else if (type instanceof Class && (Long.class.isAssignableFrom(klass = (Class)type) || klass == Long.TYPE || Boolean.class.isAssignableFrom(klass) || klass == Boolean.TYPE || String.class.isAssignableFrom(klass) || JsonValue.class.isAssignableFrom(klass) || ClaimValue.class.isAssignableFrom(klass) || Optional.class.isAssignableFrom(klass))) {
            return klass;
        }
        return null;
    }
}

