/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.authorization.impl;

import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.authorization.PermissionBasedAuthorization;
import java.util.Objects;

public class PermissionBasedAuthorizationConverter {
    private static final String FIELD_TYPE = "type";
    private static final String TYPE_PERMISSION_BASED_AUTHORIZATION = "permission";
    private static final String FIELD_PERMISSION = "permission";
    private static final String FIELD_RESOURCE = "resource";

    public static JsonObject encode(PermissionBasedAuthorization value) throws IllegalArgumentException {
        Objects.requireNonNull(value);
        JsonObject result = new JsonObject();
        result.put(FIELD_TYPE, "permission");
        result.put("permission", value.getPermission());
        if (value.getResource() != null) {
            result.put(FIELD_RESOURCE, value.getResource());
        }
        return result;
    }

    public static PermissionBasedAuthorization decode(JsonObject json) throws IllegalArgumentException {
        Objects.requireNonNull(json);
        if ("permission".equals(json.getString(FIELD_TYPE))) {
            PermissionBasedAuthorization result = PermissionBasedAuthorization.create(json.getString("permission"));
            if (json.getString(FIELD_RESOURCE) != null) {
                result.setResource(json.getString(FIELD_RESOURCE));
            }
            return result;
        }
        return null;
    }
}

