/*
 * Decompiled with CFR 0.152.
 */
package org.kie.internal.builder.conf;

import org.kie.internal.builder.ResultSeverity;
import org.kie.internal.builder.conf.MultiValueKnowledgeBuilderOption;

public class KBuilderSeverityOption
implements MultiValueKnowledgeBuilderOption {
    private static final long serialVersionUID = 1492178699571897026L;
    public static String PROPERTY_NAME = "drools.kbuilder.severity.";
    private final String key;
    private final ResultSeverity severity;

    private KBuilderSeverityOption(String key, ResultSeverity severity) {
        this.key = key;
        this.severity = severity != null ? severity : ResultSeverity.INFO;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.severity == null ? 0 : this.severity.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KBuilderSeverityOption other = (KBuilderSeverityOption)obj;
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        return this.severity == other.severity;
    }

    @Override
    public String getPropertyName() {
        return PROPERTY_NAME + this.key;
    }

    public static KBuilderSeverityOption get(String key, ResultSeverity severity) {
        return new KBuilderSeverityOption(key, severity);
    }

    public static KBuilderSeverityOption get(String key, String severityString) {
        ResultSeverity sev;
        try {
            sev = ResultSeverity.valueOf(severityString.trim().toUpperCase());
        }
        catch (IllegalArgumentException iae) {
            sev = ResultSeverity.INFO;
        }
        return new KBuilderSeverityOption(key, sev);
    }

    public String getName() {
        return this.key;
    }

    public ResultSeverity getSeverity() {
        return this.severity;
    }

    public String toString() {
        return "KBuilderResultSeverityOption ( name= " + this.key + " severity=" + (Object)((Object)this.severity) + ")";
    }
}

