/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.Objects;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.kie.kogito.explainability.api.BaseExplainabilityRequestDto;
import org.kie.kogito.explainability.api.CounterfactualSearchDomainDto;
import org.kie.kogito.explainability.api.ModelIdentifierDto;
import org.kie.kogito.tracing.typedvalue.TypedValue;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CounterfactualExplainabilityRequestDto
extends BaseExplainabilityRequestDto {
    public static final String EXPLAINABILITY_TYPE_NAME = "Counterfactual";
    public static final String COUNTERFACTUAL_ID_FIELD = "counterfactualId";
    public static final String ORIGINAL_INPUTS_FIELD = "originalInputs";
    public static final String GOALS_FIELD = "goals";
    public static final String SEARCH_DOMAINS_FIELD = "searchDomains";
    public static final String MAX_RUNNING_TIME_SECONDS_FIELD = "maxRunningTimeSeconds";
    @JsonProperty(value="counterfactualId")
    @NotNull(message="counterfactualId must be provided.")
    private @NotNull(message="counterfactualId must be provided.") String counterfactualId;
    @JsonProperty(value="originalInputs")
    @NotNull(message="originalInputs object must be provided.")
    private @NotNull(message="originalInputs object must be provided.") Map<String, TypedValue> originalInputs;
    @JsonProperty(value="goals")
    @NotNull(message="goals object must be provided.")
    private @NotNull(message="goals object must be provided.") Map<String, TypedValue> goals;
    @JsonProperty(value="searchDomains")
    @NotNull(message="searchDomains object must be provided.")
    private @NotNull(message="searchDomains object must be provided.") Map<String, CounterfactualSearchDomainDto> searchDomains;
    @JsonProperty(value="maxRunningTimeSeconds")
    @NotNull(message="maxRunningTimeSeconds must be provided.")
    private @NotNull(message="maxRunningTimeSeconds must be provided.") Long maxRunningTimeSeconds;

    private CounterfactualExplainabilityRequestDto() {
    }

    public CounterfactualExplainabilityRequestDto(@NotNull String executionId, @NotNull String counterfactualId, @NotBlank String serviceUrl, @NotNull ModelIdentifierDto modelIdentifier, @NotNull Map<String, TypedValue> originalInputs, @NotNull Map<String, TypedValue> goals, @NotNull Map<String, CounterfactualSearchDomainDto> searchDomains, Long maxRunningTimeSeconds) {
        super(executionId, serviceUrl, modelIdentifier);
        this.counterfactualId = Objects.requireNonNull(counterfactualId);
        this.originalInputs = Objects.requireNonNull(originalInputs);
        this.goals = Objects.requireNonNull(goals);
        this.searchDomains = Objects.requireNonNull(searchDomains);
        this.maxRunningTimeSeconds = maxRunningTimeSeconds;
    }

    public String getCounterfactualId() {
        return this.counterfactualId;
    }

    public Map<String, TypedValue> getOriginalInputs() {
        return this.originalInputs;
    }

    public Map<String, TypedValue> getGoals() {
        return this.goals;
    }

    public Map<String, CounterfactualSearchDomainDto> getSearchDomains() {
        return this.searchDomains;
    }

    public Long getMaxRunningTimeSeconds() {
        return this.maxRunningTimeSeconds;
    }
}

