/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.core.provider;

import io.cloudevents.CloudEventExtensions;
import io.cloudevents.Extension;
import io.cloudevents.core.extensions.DatarefExtension;
import io.cloudevents.core.extensions.DistributedTracingExtension;
import io.cloudevents.lang.Nullable;
import java.util.HashMap;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class ExtensionProvider {
    private final HashMap<Class<?>, Supplier<?>> extensionFactories = new HashMap();

    public static ExtensionProvider getInstance() {
        return SingletonContainer.INSTANCE;
    }

    private ExtensionProvider() {
        this.registerExtension(DistributedTracingExtension.class, DistributedTracingExtension::new);
        this.registerExtension(DatarefExtension.class, DatarefExtension::new);
    }

    public <T extends Extension> void registerExtension(Class<T> extensionClass, Supplier<T> factory) {
        this.extensionFactories.put(extensionClass, factory);
    }

    @Nullable
    public <T extends Extension> T parseExtension(Class<T> extensionClass, CloudEventExtensions eventExtensions) {
        Supplier<?> factory = this.extensionFactories.get(extensionClass);
        if (factory != null) {
            Extension ext = (Extension)factory.get();
            ext.readFrom(eventExtensions);
            return (T)ext;
        }
        return null;
    }

    private static class SingletonContainer {
        private static final ExtensionProvider INSTANCE = new ExtensionProvider();

        private SingletonContainer() {
        }
    }
}

