/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.openapi.runtime;

import io.quarkus.smallrye.openapi.runtime.OpenApiConstants;
import io.smallrye.openapi.api.OpenApiConfigImpl;
import io.smallrye.openapi.api.OpenApiDocument;
import io.smallrye.openapi.runtime.OpenApiProcessor;
import io.smallrye.openapi.runtime.OpenApiStaticFile;
import io.smallrye.openapi.runtime.io.Format;
import io.smallrye.openapi.runtime.io.OpenApiSerializer;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

@ApplicationScoped
public class OpenApiDocumentService {
    private byte[] jsonDocument;
    private byte[] yamlDocument;

    @PostConstruct
    void create() throws IOException {
        block25: {
            ClassLoader cl = OpenApiConstants.classLoader == null ? Thread.currentThread().getContextClassLoader() : OpenApiConstants.classLoader;
            try (InputStream is = cl.getResourceAsStream("META-INF/quarkus-generated-openapi-doc." + (Object)((Object)Format.JSON));){
                if (is != null) {
                    try (OpenApiStaticFile staticFile = new OpenApiStaticFile(is, Format.JSON);){
                        Config config = ConfigProvider.getConfig();
                        OpenApiConfigImpl openApiConfig = new OpenApiConfigImpl(config);
                        OpenApiDocument document = OpenApiDocument.INSTANCE;
                        document.reset();
                        document.config(openApiConfig);
                        document.modelFromStaticFile(OpenApiProcessor.modelFromStaticFile(staticFile));
                        document.filter(OpenApiProcessor.getFilter(openApiConfig, cl));
                        document.initialize();
                        this.jsonDocument = OpenApiSerializer.serialize(document.get(), Format.JSON).getBytes(StandardCharsets.UTF_8);
                        this.yamlDocument = OpenApiSerializer.serialize(document.get(), Format.YAML).getBytes(StandardCharsets.UTF_8);
                        document.reset();
                        document = null;
                        break block25;
                    }
                }
                throw new IOException("Could not find [META-INF/quarkus-generated-openapi-doc." + (Object)((Object)Format.JSON) + "]");
            }
        }
    }

    public byte[] getJsonDocument() {
        return this.jsonDocument;
    }

    public byte[] getYamlDocument() {
        return this.yamlDocument;
    }

    public byte[] getDocument(Format format) {
        if (format.equals((Object)Format.JSON)) {
            return this.getJsonDocument();
        }
        return this.getYamlDocument();
    }
}

