/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.reactivemessaging.runtime;

import io.quarkus.runtime.StartupEvent;
import io.quarkus.smallrye.reactivemessaging.runtime.QuarkusWorkerPoolRegistry;
import io.quarkus.smallrye.reactivemessaging.runtime.SmallRyeReactiveMessagingRecorder;
import io.quarkus.smallrye.reactivemessaging.runtime.WorkerConfiguration;
import io.smallrye.reactive.messaging.extension.ChannelConfiguration;
import io.smallrye.reactive.messaging.extension.EmitterConfiguration;
import io.smallrye.reactive.messaging.extension.MediatorManager;
import javax.annotation.Priority;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.Initialized;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.DeploymentException;
import javax.inject.Inject;

@Dependent
public class SmallRyeReactiveMessagingLifecycle {
    @Inject
    MediatorManager mediatorManager;

    void onStaticInit(@Observes @Initialized(value=ApplicationScoped.class) Object event, SmallRyeReactiveMessagingRecorder.SmallRyeReactiveMessagingContext context, QuarkusWorkerPoolRegistry workerPoolRegistry) {
        this.mediatorManager.addAnalyzed(context.getMediatorConfigurations());
        for (WorkerConfiguration worker : context.getWorkerConfigurations()) {
            workerPoolRegistry.defineWorker(worker.getClassName(), worker.getMethodName(), worker.getPoolName());
        }
        for (EmitterConfiguration emitter : context.getEmitterConfigurations()) {
            this.mediatorManager.addEmitter(emitter);
        }
        for (ChannelConfiguration channel : context.getChannelConfigurations()) {
            this.mediatorManager.addChannel(channel);
        }
    }

    void onApplicationStart(@Observes @Priority(value=1000) StartupEvent event) {
        try {
            this.mediatorManager.start();
        }
        catch (Exception e) {
            if (e instanceof DeploymentException) {
                throw e;
            }
            throw new DeploymentException(e);
        }
    }
}

